using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Serialization;

using HttpService.API;

namespace Boon.IO.File
{
    /// <summary>
    /// jRjRt@C̑f[^ێNXłB
    /// </summary>
    [Serializable()]
    [XmlRoot("VideoFileDataRoot")]
    public class VideoFileData
    {
        /// <summary>
        /// IDłB
        /// ʏusmvn܂镶łB
        /// </summary>
        private string videoID_;

        /// <summary>
        /// ^CgłB
        /// </summary>
        private string videoTitle_ = "";

        /// <summary>
        /// t@C̏ԂłB
        /// </summary>
        private int videoFileStatus_ = -1;

        /// <summary>
        /// t@C̃TCYłB
        /// </summary>
        private long videoFileSize_ = 0;

        /// <summary>
        /// t@C̃_E[hς݂̃TCYłB
        /// </summary>
        private long videoFileDownloadedSize_ = 0;

        /// <summary>
        /// t@C̊gqłB
        /// </summary>
        private string videoFileExtension_ = "";

        /// <summary>
        /// o^ꂽԂlłB
        /// </summary>
        private long registeredTime_ = 0;

        /// <summary>
        /// _E[h̃^XNIDłB
        /// NicoServiceɓo^ꂽ̂ݗp܂B
        /// </summary>
        private long taskID_ = 0;

        /// <summary>
        /// URLłB
        /// </summary>
        private string fileUrl_ = "";

        /// <summary>
        /// ̃t@CpXłB
        /// </summary>
		private string videoFilePath_ = "";

        /// <summary>
        /// Rg̃t@CpXłB
        /// </summary>
        private string commentFilePath_ = "";

        /// <summary>
        /// Rg_E[h邩ǂ̔lłB
        /// </summary>
        private bool isCommentDownload_ = true;

        /// <summary>
        /// t@C_E[h邩ǂ̔lłB
        /// </summary>
        private bool isMovieDownload_ = true;

        /// <summary>
        /// t@C_E[hɁAt@C㏑邩ǂ̔lłB
        /// </summary>
        private bool isMovieOverwritten_ = false;

        /// <summary>
        /// _E[hJnlłB
        /// </summary>
        private long downloadStartTime_ = 0;

        /// <summary>
        /// _E[h҂Ӗ萔łB
        /// </summary>
        public const int DOWNLOAD_WAITING = 0;

        /// <summary>
        /// _E[hӖ萔łB
        /// </summary>
        public const int DOWNLOAD_PROCESSING = 1;

        /// <summary>
        /// _E[hӖ萔łB
        /// </summary>
        public const int DOWNLOAD_COMPLETED = 2;

        /// <summary>
        /// _E[hLZӖ萔łB
        /// </summary>
        public const int DOWNLOAD_CANCELLED = 9;

        /// <summary>
        /// _E[hG[Ӗ萔łB
        /// </summary>
        public const int DOWNLOAD_ERROR = 10;

        /// <summary>
        /// RXgN^łB
        /// VACYpȂ̂ŁAʏ͌ĂяoȂ悤ɂĂB
        /// </summary>
        public VideoFileData()
        {
        }

        /// <summary>
        /// RXgN^łB
        /// </summary>
        /// <param name="movieID">ID</param>
        public VideoFileData(string videoID)
        {
            this.videoID_ = videoID;
            this.fileUrl_ = BoonCommon.Url_NicoRoot + "watch/" + videoID;

            try
            {
                HttpService.API.Request.ThumbnailInfoResponse res = NicoService.Instance.ThumbnailInfo(videoID, null);
                this.videoTitle_ = HttpService.Core.ReplaceInvalidFileNameChars(res.Contents.Title);
            }
            catch (Exception)
            {
                this.videoTitle_ = "@";
            }
        }

        /// <summary>
        /// RXgN^łB
        /// </summary>
        /// <param name="videoID">ID</param>
        /// <param name="videoTitle">^Cg</param>
        public VideoFileData(string videoID, string videoTitle)
        {
            this.videoID_ = videoID;
            this.fileUrl_ = BoonCommon.Url_NicoRoot + "watch/" + videoID;
            this.videoTitle_ = videoTitle;
        }

        /// <summary>
        /// IuWFNgێ铮IDłB
        /// </summary>
        [XmlElement(ElementName = "VideoID", IsNullable = false)]
        public string videoID
        {
            get
            {
                return (this.videoID_);
            }

            set
            {
                this.videoID_ = value;
            }
        }

        /// <summary>
        /// IuWFNgێ铮^CgłB
        /// </summary>
        [XmlElement(ElementName = "VideoTitle", IsNullable = false)]
        public string videoTitle
        {
            get
            {
                return (this.videoTitle_);
            }

            set
            {
                this.videoTitle_ = value;
            }
        }

        /// <summary>
        /// IuWFNgێ铮t@C̏ԂłB
        /// </summary>
        [XmlElement(ElementName = "VideoFileStatus", IsNullable = false)]
        public int videoFileStatus
        {
            get
            {
                return (this.videoFileStatus_);
            }

            set
            {
                this.videoFileStatus_ = value;
            }
        }

        /// <summary>
        /// IuWFNgێ铮t@C̃TCYłB
        /// </summary>
        [XmlElement(ElementName = "VideoFileSize", IsNullable = false)]
        public long videoFileSize
        {
            get
            {
                return (this.videoFileSize_);
            }

            set
            {
                this.videoFileSize_ = value;
            }
        }

        /// <summary>
        /// IuWFNgێ铮̃_E[hς݃t@CTCYłB
        /// </summary>
        [XmlElement(ElementName = "VideoFileDownloadedSize", IsNullable = false)]
        public long videoFileDownloadedSize
        {
            get
            {
                return (this.videoFileDownloadedSize_);
            }

            set
            {
                this.videoFileDownloadedSize_ = value;
            }
        }

        /// <summary>
        /// IuWFNgێ铮̊gqłB
        /// </summary>
        [XmlElement(ElementName = "VideoFileExtension", IsNullable = true)]
        public string videoFileExtension
        {
            get
            {
                return (this.videoFileExtension_);
            }

            set
            {
                this.videoFileExtension_ = value;
            }
        }

        /// <summary>
        /// IuWFNgێ铮̓o^łB
        /// </summary>
        [XmlElement(ElementName = "RegisteredTime", IsNullable = false)]
        public long registeredTime
        {
            get
            {
                return (this.registeredTime_);
            }

            set
            {
                this.registeredTime_ = value;
            }
        }

        /// <summary>
        /// IuWFNgێ铮URLłB
        /// </summary>
        [XmlElement(ElementName = "FileUrl", IsNullable = false)]
        public string fileUrl
        {
            get
            {
                return (this.fileUrl_);
            }

            set
            {
                this.fileUrl_ = value;
            }
        }

        /// <summary>
        /// IuWFNgێ铮̃t@CpXłB
        /// </summary>
        [XmlElement(ElementName = "VideoFilePath", IsNullable = false)]
        public string videoFilePath
        {
            get
            {
                return (this.videoFilePath_);
            }

            set
            {
                this.videoFilePath_ = value;
            }
        }

        /// <summary>
        /// IuWFNgێRg̃t@CpXłB
        /// </summary>
        [XmlElement(ElementName = "CommentFilePath", IsNullable = false)]
        public string commentFilePath
        {
            get
            {
                return (this.commentFilePath_);
            }

            set
            {
                this.commentFilePath_ = value;
            }
        }

        /// <summary>
        /// Rg_E[h邩ǂ̔lłB
        /// </summary>
        [XmlElement(ElementName = "IsCommentDownload", IsNullable = false)]
        public bool isCommentDownload
        {
            get
            {
                return (this.isCommentDownload_);
            }

            set
            {
                this.isCommentDownload_ = value;
            }
        }

        /// <summary>
        /// _E[h邩ǂ̔lłB
        /// </summary>
        [XmlElement(ElementName = "IsMovieDownload", IsNullable = false)]
        public bool isMovieDownload
        {
            get
            {
                return (this.isMovieDownload_);
            }

            set
            {
                this.isMovieDownload_ = value;
            }
        }

        /// <summary>
        /// t@C_E[hɁAt@C㏑邩ǂ̔lłB
        /// </summary>
        [XmlElement(ElementName = "IsMovieOverwritten", IsNullable = false)]
        public bool isMovieOverwritten
        {
            get
            {
                return (this.isMovieOverwritten_);
            }

            set
            {
                this.isMovieOverwritten_ = value;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        [XmlAnyElement()]
        public XmlElement[] Any;

        /// <summary>
        /// IuWFNgێ^XNIDłB
        /// </summary>
        public long taskID
        {
            get
            {
                return (this.taskID_);
            }

            set
            {
                this.taskID_ = value;
            }
        }

        /// <summary>
        /// _E[hJnlłB
        /// </summary>
        public long downloadStartTime
        {
            get
            {
                return (this.downloadStartTime_);
            }

            set
            {
                this.downloadStartTime_ = value;
            }
        }

        /// <summary>
        /// Ŏw肳ꂽԃXe[^XɑΉ郁bZ[W擾܂B
        /// </summary>
        /// <param name="status">ԃXe[^X萔</param>
        /// <returns>Ŏw肳ꂽԃXe[^XɑΉ郁bZ[W</returns>
        public static string GetStatusMessage(int status)
        {
            switch (status)
            {
                case VideoFileData.DOWNLOAD_CANCELLED :
                    return ("LZ");

                case VideoFileData.DOWNLOAD_COMPLETED :
                    return ("");

                case VideoFileData.DOWNLOAD_ERROR :
                    return ("G[");

                case VideoFileData.DOWNLOAD_PROCESSING :
                    return ("_E[h");

                case VideoFileData.DOWNLOAD_WAITING :
                    return ("_E[h҂");

                default :
                    return ("");
            }
        }

        /// <summary>
        /// IuWFNgێԃXe[^XɑΉbZ[W擾܂B
        /// </summary>
        /// <returns>IuWFNgێԃXe[^XɑΉbZ[W</returns>
        public string GetStatusMessage()
        {
            return (VideoFileData.GetStatusMessage(this.videoFileStatus_));
        }
    }
}
