using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows.Forms;

using Boon.IO.File;
using HttpService.API;
using HttpService.API.Request;

namespace Boon.Net
{
	/// <summary>
	/// _E[h𑀍삷NXłB
	/// </summary>
	class BoonDownloadManager
	{
		#region Static Members

		/// <summary>
		/// ̃NX̗B̃IuWFNgłB
		/// </summary>
		private static BoonDownloadManager manager__ = new BoonDownloadManager();

		/// <summary>
		/// _E[hsL[łB
		/// s̃_E[h͊܂܂܂B
		/// </summary>
		private static HttpService.Collections.OrderedDictionary<string, ListViewItem> downloadVideoKeys__ = new HttpService.Collections.OrderedDictionary<string, ListViewItem>();

		/// <summary>
		/// ݎs̃XbhێDictionaryIuWFNgłB
		/// L[͓IDłB
		/// </summary>
		private static Dictionary<string, DownloadVideoThread> videoThreadDictionary__ = new Dictionary<string, DownloadVideoThread>();

		#endregion

		/// <summary>
		/// RXgN^łB
		/// O͌Ăяo܂B
		/// </summary>
		private BoonDownloadManager()
		{
		}

		/// <summary>
		/// _E[hLZꂽۂ̃CxgłB
		/// </summary>
		public event DownloadCancelledHandler DownloadCancelled;

		/// <summary>
		/// ̃NX̗B̃IuWFNgłB
		/// </summary>
		public static BoonDownloadManager Instance
		{
			get { return (BoonDownloadManager.manager__); }
		}

		#region Methods

		/// <summary>
		/// _E[h̓悪ۂɃ_E[hs܂B
		/// </summary>
		/// <param name="videoID">_E[h铮ID</param>
		/// <param name="lvi">_E[h󋵂\ĂListViewItemIuWFNg</param>
		/// <param name="isDownloadMovieOnly">t@Ĉ݂_E[h邩ǂ̔l</param>
		private void startDownload(string videoID, ListViewItem lvi, bool isDownloadMovieOnly)
		{
			DownloadVideoThread dvth = new DownloadVideoThread(lvi.Name, lvi, isDownloadMovieOnly);
			BoonDownloadManager.videoThreadDictionary__.Add(videoID, dvth);
			ThreadStart ts = new ThreadStart(dvth.DownloadVideo);
			Thread newThread = new Thread(ts);
			newThread.Start();
		}

		/// <summary>
		/// _E[h𒆎~܂B
		/// </summary>
		/// <param name="videoID">~_E[h̓ID</param>
		public void stopDownload(string videoID)
		{
			if(BoonDownloadManager.downloadVideoKeys__.ContainsKey(videoID))
			{
				ListViewItem lvi = (ListViewItem)BoonDownloadManager.downloadVideoKeys__[videoID];
				VideoFileData vfd = (VideoFileData)lvi.Tag;
				vfd.videoFileStatus = VideoFileData.DOWNLOAD_CANCELLED;
				lvi.SubItems[1].Text = vfd.GetStatusMessage();
				BoonDownloadManager.downloadVideoKeys__.Remove(videoID);
				return;
			}

			DownloadCancelled(this, new DownloadCancelledEventArgs(videoID));
		}

		/// <summary>
		/// _E[h\񃊃XgɓIDǉ܂B
		/// </summary>
		/// <param name="videoID">\ǉ铮ID</param>
		/// <param name="lvi">_E[h󋵂\ĂListViewItemIuWFNg</param>
		/// <param name="isDownloadMovieOnly">t@Ĉ݂_E[h邩ǂ̔l</param>
		public static void addReservation(string videoID, ListViewItem lvi, bool isDownloadMovieOnly)
		{
			if(BoonDownloadManager.downloadVideoKeys__.ContainsKey(videoID))
			{
				BoonDownloadManager.manager__.stopDownload(videoID);
			}

			BoonDownloadManager.downloadVideoKeys__.Add(videoID, lvi);
			BoonDownloadManager.manager__.startDownload(videoID, lvi, isDownloadMovieOnly);
		}

		/// <summary>
		/// Ŏw肳ꂽID_E[hĂXbhAǗDictionaryIuWFNg폜܂B
		/// </summary>
		/// <param name="videoID">ǗDictionaryIuWFNg폜_E[hXbh̓ID</param>
		public void removeThread(string videoID)
		{
			if(BoonDownloadManager.videoThreadDictionary__.ContainsKey(videoID))
			{
				DownloadVideoThread dvh = BoonDownloadManager.videoThreadDictionary__[videoID];
				dvh.cancelDownload();
				BoonDownloadManager.videoThreadDictionary__.Remove(videoID);
			}
		}

		/// <summary>
		/// ׂẴ_E[hXbh~܂B
		/// </summary>
		public void removeAllThread()
		{
			foreach(string videoID in BoonDownloadManager.videoThreadDictionary__.Keys)
			{
				DownloadVideoThread dvh = BoonDownloadManager.videoThreadDictionary__[videoID];
				dvh.cancelDownload();
			}

			BoonDownloadManager.videoThreadDictionary__.Clear();
		}

		#endregion


		/// <summary>
		/// _E[hLZꂽۂ̃CxgłB
		/// </summary>
		/// <param name="sender">Cxg𔭍sIuWFNg</param>
		/// <param name="e">p[^ێDownloadCancelledEventArgsIuWFNg</param>
		public delegate void DownloadCancelledHandler(object sender, DownloadCancelledEventArgs e);
	}

	#region Custom Classes


	/// <summary>
	/// _E[hLZ̃CxgێNXłB
	/// </summary>
	public class DownloadCancelledEventArgs : EventArgs
	{
		/// <summary>
		/// LZ铮̓ID
		/// </summary>
		protected string videoID_;

		/// <summary>
		/// RXgN^łB
		/// </summary>
		/// <param name="videoID">LZ铮̓ID</param>
		public DownloadCancelledEventArgs(string videoID)
		{
			this.videoID_ = videoID;
		}

		/// <summary>
		/// LZ铮̓ID
		/// </summary>
		public string VideoID
		{
			get
			{
				return (this.videoID_);
			}
		}
	}

	/// <summary>
	/// _E[hsXbhłB
	/// 1ɑ΂A1IuWFNgΉ܂B
	/// </summary>
	public class DownloadVideoThread
	{
		/// <summary>
		/// IuWFNg_E[h铮IDłB
		/// </summary>
		private string videoID_;

		/// <summary>
		/// ̃Xbh_E[h铮ListViewItemIuWFNgłB
		/// </summary>
		private ListViewItem lvi_;

		/// <summary>
		/// _E[h̃^XNIDłB
		/// </summary>
		private int taskID_;

		/// <summary>
		/// XbhĂ邩ǂ̔lłB
		/// falseɂȂƁAIs܂B
		/// </summary>
		private volatile bool isAlive_ = true;

		/// <summary>
		/// t@Ĉ݂_E[h邩ǂ̔lłB
		/// trueȂÂ݃_E[h܂B
		/// </summary>
		private bool isDownloadMovieOnly_ = false;

		/// <summary>
		/// RXgN^łB
		/// </summary>
		/// <param name="videoID">_E[h铮ID</param>
		/// <param name="lvi">_E[h󋵂\ĂListViewItemIuWFNg</param>
		/// <param name="isDownloadMovieOnly">t@Ĉ݂_E[h邩ǂ̔l</param>
		public DownloadVideoThread(string videoID, ListViewItem lvi, bool isDownloadMovieOnly)
		{
			this.videoID_ = videoID;
			this.lvi_ = lvi;
			this.isDownloadMovieOnly_ = isDownloadMovieOnly;

			NicoService.Instance.DownloadVideoBegin += this.nico_DownloadVideoBegin;
			NicoService.Instance.DownloadVideoProgress += this.nico_DownloadVideoProgress;
			NicoService.Instance.DownloadVideoCompleted += this.nico_DownloadVideoCompleted;
			BoonDownloadManager.Instance.DownloadCancelled += new BoonDownloadManager.DownloadCancelledHandler(this.nico_DownloadCancelled);
		}

		/// <summary>
		/// _E[h𒆎~܂B
		/// </summary>
		public void cancelDownload()
		{
			if(this.isAlive_)
			{
				NicoService.Instance.Cancel(this.taskID_);
				this.isAlive_ = false;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="videoID"></param>
		private void nico_DownloadCancelled(object sender, DownloadCancelledEventArgs e)
		{
			if(!this.videoID_.Equals(e.VideoID)) return;

			this.cancelDownload();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void nico_DownloadVideoCompleted(AsyncHttpRequest sender, DownloadVideoCompletedEventArgs e)
		{
			if(!this.videoID_.Equals(((ListViewItem)(sender.Tag)).Name)) return;
			VideoFileData vfd = (VideoFileData)this.lvi_.Tag;

			if(e.Cancelled)
			{
				vfd.videoFileStatus = VideoFileData.DOWNLOAD_CANCELLED;
			}
			else if(e.Error != null)
			{
				MessageBox.Show(e.Error.Message);
				vfd.videoFileStatus = VideoFileData.DOWNLOAD_ERROR;
			}
			else
			{
				string header = string.Format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- BoonSutazioData={0} -->\n", e.Contents.VideoId);
				string footer = "";
				vfd.commentFilePath = e.Contents.Directory + @"\" + e.Contents.FileName + ".xml";
				e.Contents.Thread.SaveThreadXml(NicoThreadType.All, vfd.commentFilePath, Encoding.GetEncoding("UTF-8"), header, footer);
				vfd.videoFileStatus = VideoFileData.DOWNLOAD_COMPLETED;
				this.lvi_.SubItems[2].Text = string.Format("{0:F4}/{0:F4}", ((double)e.Contents.Size) / (1024 * 1024));
				double speed = (((double)e.Contents.Download / (double)e.Contents.Milliseconds) * 1.024);
				this.lvi_.SubItems[5].Text = string.Format("{0:F2}KB/s", speed);
				this.lvi_.SubItems[6].Text = "";
				this.lvi_.SubItems[7].Text = e.Contents.FileExt.Replace(".", "");
				vfd.videoFileDownloadedSize = e.Contents.Size;
				vfd.videoFileSize = e.Contents.Size;
			}

			this.isAlive_ = false;
			this.lvi_.SubItems[1].Text = vfd.GetStatusMessage();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void nico_DownloadVideoProgress(AsyncHttpRequest sender, DownloadVideoProgressEventArgs e)
		{
			if(!this.videoID_.Equals(((ListViewItem)(sender.Tag)).Name)) return;
			VideoFileData vfd = (VideoFileData)this.lvi_.Tag;

			if(e.Cancelled)
			{
				vfd.videoFileStatus = VideoFileData.DOWNLOAD_CANCELLED;
				this.lvi_.SubItems[1].Text = vfd.GetStatusMessage();
				this.isAlive_ = false;
				return;
			}
			else if(e.Error != null)
			{

				MessageBox.Show(e.Error.Message);
				this.isAlive_ = false;
				return;
			}

			this.lvi_.SubItems[2].Text = string.Format("{0:F4}/{1:F4}", ((double)e.Contents.Download) / (1024 * 1024), ((double)e.Contents.Size) / (1024 * 1024));
			if(e.Contents.Size != 0)
			{
				this.lvi_.SubItems[3].Text = string.Format("{0:F1}%", ((double)e.Contents.Download * 100 / e.Contents.Size));
				vfd.videoFileDownloadedSize = e.Contents.Download;
				vfd.videoFileSize = e.Contents.Size;
			}

			double speed = (((double)e.Contents.Download / (double)e.Contents.Milliseconds) * 1.024);
			this.lvi_.SubItems[5].Text = string.Format("{0:F2}KB/s", speed);

			int remain = (int)(((e.Contents.Size - e.Contents.Download) / 1024) / speed);
			this.lvi_.SubItems[4].Text = string.Format("{0}b", remain);
		}

		/// <summary>
		/// _E[hJnꂽۂ̃CxgłB
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void nico_DownloadVideoBegin(AsyncHttpRequest sender, DownloadVideoBeginEventArgs e)
		{
			if(!this.videoID_.Equals(((ListViewItem)(sender.Tag)).Name)) return;

			//tpX̑݃`FbNAG[Ȃ^Cgēxt^iIDȂ̂ŁAȂ͂j
			string newPath = e.Contents.FullPath;
			if(System.IO.File.Exists(newPath))
			{
				newPath = this.getNewPath(newPath);
				e.Contents.FullPath = newPath;
			}

			if(e.Error != null)
			{
				MessageBox.Show(e.Error.Message);
				this.isAlive_ = false;
				return;
			}

			VideoFileData vfd = (VideoFileData)this.lvi_.Tag;
			vfd.videoFileStatus = VideoFileData.DOWNLOAD_PROCESSING;
			vfd.videoFilePath = newPath;

			if("".Equals(newPath))
			{
				MessageBox.Show("t@C𐶐ł܂B:" + e.Contents.FullPath);
				vfd.videoFileStatus = VideoFileData.DOWNLOAD_ERROR;
				return;
			}

			this.lvi_.SubItems[1].Text = vfd.GetStatusMessage();
			this.lvi_.SubItems[2].Text = "";
			this.lvi_.SubItems[3].Text = "";
			this.lvi_.SubItems[4].Text = "";
			this.lvi_.SubItems[5].Text = "";
			vfd.downloadStartTime = DateTime.Now.Ticks;
		}

		/// <summary>
		/// Vt@C𐶐܂B
		/// ʔԂ1`99܂łtāA݃`FbN܂Aׂđ݂ꍇ͋󕶎Ԃ܂B
		/// </summary>
		/// <param name="oldPath">x[XƂȂtpX</param>
		/// <returns>VtpX</returns>
		private string getNewPath(string oldPath)
		{
			string videoTitle = ((VideoFileData)this.lvi_.Tag).videoTitle;
			string videoID = ((VideoFileData)this.lvi_.Tag).videoID;
			string saveFolderPath = BoonSerializableConfig.getInstance().saveFolderPath;
			bool isKeyAddedToFilename = BoonSerializableConfig.getInstance().isKeyAddedToFilename;

			for(int i = 0; i < 99; i++)
			{
				string newPath =
					string.Format
					(
						@"{0}\{1}{2}({3}).xml",
						saveFolderPath,
						videoTitle,
						(isKeyAddedToFilename) ? "(" + videoID + ")" : "",
						i
					);

				if(!System.IO.File.Exists(newPath))
				{
					return (newPath);
				}
			}

			return ("");
		}

		/// <summary>
		/// t@C̃_E[hs܂B
		/// </summary>
		public void DownloadVideo()
		{
			string saveFolderPath = BoonSerializableConfig.getInstance().saveFolderPath;
			bool isKeyAddedToFilename = BoonSerializableConfig.getInstance().isKeyAddedToFilename;
			this.taskID_ = NicoService.Instance.DownloadVideoAsync(this.videoID_, saveFolderPath + @"\<TITLE>" + ((isKeyAddedToFilename) ? "(<ID>)" : "") + ".<EXT>", true, true, true, this.lvi_);

			while(this.isAlive_)
			{
				Thread.Sleep(1000);
			}

			this.Dispose();
		}

		/// <summary>
		/// IuWFNgێ铮IDłB
		/// </summary>
		public string videoID
		{
			get
			{
				return (this.videoID_);
			}
		}

		/// <summary>
		/// Is܂B
		/// Cxgnh폜܂B
		/// </summary>
		private void Dispose()
		{
			NicoService.Instance.DownloadVideoBegin -= this.nico_DownloadVideoBegin;
			NicoService.Instance.DownloadVideoProgress -= this.nico_DownloadVideoProgress;
			NicoService.Instance.DownloadVideoCompleted -= this.nico_DownloadVideoCompleted;

			BoonDownloadManager.Instance.DownloadCancelled -= new BoonDownloadManager.DownloadCancelledHandler(this.nico_DownloadCancelled);

			BoonDownloadManager.Instance.removeThread(this.videoID_);
		}

	}

	#endregion

}
