using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.IO;
using System.Threading;

namespace Boon.Forms.Dialog
{
	using BeginFrags = DownloadBeginResult;

	/// <summary>
	/// ɑ݂t@Cɏ㏑悤ƂĂ鎞ɁAmFׂ̈ɕ\_CAOłB
	///  ShowDialog(IWin32Window, FileInfo[], long, ref string) ȊOShowDialog\bh͎gpȂłB
	/// </summary>
	public partial class DownFileExistDialog : Form
	{
		const string StringFormat_size = "{0} KB";
		const string ToStringFormat_date = "yyyy/MM/dd  hh:mm:ss";

		public DownFileExistDialog()
		{
			InitializeComponent();
		}

		int _result = 0;

		/// <summary>
		/// Kvȃf[^󂯎ă_CAO\܂B̃I[o[ChȊOgpȂłB
		/// ߂l<see cref="Boon.Plugin.SDK.DownloadService.DownloadBeginResult"/>Œ`Int32^tǑlłB
		/// </summary>
		/// <param name="matchFiles">dt@CFileInfo</param>
		/// <param name="downfileSize">_E[h悤ƂĂRec̃TCYibytePʂł̒lFInt64^j</param>
		/// <param name="downfilepath">_E[h̃tpXB̈̓_CAOł̑ŒlύX邱Ƃ܂B</param>
		/// <returns><see cref="Boon.Plugin.SDK.DownloadService.DownloadBeginResult"/>Œ`Int32^tǑlB</returns>
		public int ShowDialog(IWin32Window owner,FileInfo[] matchFiles, long downfileSize, ref string downfilepath)
		{
			this.listboxFileFound.Items.AddRange(matchFiles);
			this.listboxFileFound.SelectedItem = matchFiles[0];
			this.txtDownFilePath.Text = downfilepath;
			this.txtDownFilePath.Tag = downfilepath;

			this.updateFileInfoDisplay(matchFiles[0]);
			this.lbDownloadSize.Text = String.Format(StringFormat_size, downfileSize / 1024L);

			this._result = 0;
			this.ShowDialog(owner);

			if(this._result == 0) { this._result = BeginFrags.F1Cancel; }

			if((this._result & BeginFrags.FI13PlayMovie) == BeginFrags.FI13PlayMovie)
			{
				FileInfo fi = (this.listboxFileFound.SelectedItem as FileInfo);
				if(fi == null && this.listboxFileFound.Items.Count != 0) { fi = this.listboxFileFound.Items[0] as FileInfo; }
				downfilepath = fi != null ? fi.FullName
				   : this.txtDownFilePath.Tag as string ?? "";
			}
			else if((this._result & BeginFrags.F1Continue) == BeginFrags.F1Continue)
			{
				downfilepath = this.txtDownFilePath.Text;
			}
			return this._result;
		}

		private void updateFileInfoDisplay(FileInfo file)
		{
			if(file != null && file.Exists)
			{
				this.lbFileSize.Text = String.Format(StringFormat_size, file.Length / 1024);
				this.lbFileUpdated.Text = file.LastWriteTime.ToString(ToStringFormat_date);
			}
			else
			{
				this.lbFileSize.Text = String.Format(StringFormat_size, " --- ");
				this.lbFileUpdated.Text = "----  ----  ----  --";
			}
		}
		private bool validatePath()
		{
			if(!Path.IsPathRooted(this.txtDownFilePath.Text))
			{
				MessageBox.Show("pX̏܂");
				return false;
			}
			return true;
		}
		public void Release()
		{
			this.listboxFileFound.Items.Clear();
		}

		#region Handlers

		private void btnContinue_Click(object sender, EventArgs e)
		{
			bool changed = this.txtDownFilePath.Text != (this.txtDownFilePath.Tag as string);
			this._result = BeginFrags.F1Continue;
			if(changed) { this._result |= BeginFrags.F2NameChanged; }
			this.DialogResult = DialogResult.OK;
		}
		private void btnPlayFile_Click(object sender, EventArgs e)
		{
			this._result = BeginFrags.FI13PlayMovie;
			this.DialogResult = DialogResult.OK;
		}
		private void btnCancel_Click(object sender, EventArgs e)
		{
			this._result = BeginFrags.F1Cancel;
			this.DialogResult = DialogResult.OK;
		}
		private void btnRefDialog_Click(object sender, EventArgs e)
		{
		}

		private void listboxFileFound_SelectedIndexChanged(object sender, EventArgs e)
		{
			this.updateFileInfoDisplay(this.listboxFileFound.SelectedItem as FileInfo);
		}
		private void listboxFileFound_MouseDoubleClick(object sender, MouseEventArgs e)
		{
		}

		#endregion

	}
	/// <summary>
	/// <para><see cref="DownloadBeginEventArgs.BeginEventResult"/>ŎgptOl`܂B</para>
	/// FnXXXXŒ`etÓAn̒lقȂ̂gݍ킹Ďgp܂B
	/// ̃tȌ16rbg̓zXg̏Ɏgp܂BvOCŉ߂Kv͉̂16rbgłB
	/// </summary>
	/// <remarks>
	/// Ǝ̒l𖄂ߍޏꍇ͂Ȃׂ8rbggpĂB
	/// ܂A16bit͓Ǝ̒l𖄂ߍނƂ֎~Ă܂B
	/// ȊOɒl𖄂ߍޏꍇ́ÃtOƂ̃rbgZɉe^ȂƂmFĂB
	/// </remarks>
	public static class DownloadBeginResult
	{
		/// <summary>
		/// _E[h𑱂܂Bw肳ꂽۑɃt@C݂ꍇ͏㏑܂B
		/// i0x_0000_8000j
		/// <para>̃tO̓vOCŏĂB</para>
		/// </summary>
		public const int F1Continue = 0x00008000;
		/// <summary>
		/// _E[hLZ܂Bi0x_0000_4000j
		/// <para>̃tO̓vOCŏĂB</para>
		/// </summary>
		public const int F1Cancel = 0x00004000;

		/// <summary>
		/// F1ContinueɂāAۑ悪ύXꂽƂ\܂B
		///i0x_0000_1000j
		/// <para>̃tO̓vOCŏĂB</para>
		/// </summary>
		public const int F2NameChanged = 0x00001000;

		/// <summary>
		/// Đ܂B̃tOw肵F1tO͏F1Cancelw肳܂B
		/// i0x_3000_F000j
		/// <para>̃tO̓zXg܂BvOCŏKv͂܂B</para>
		/// </summary>
		public const int FI13PlayMovie = 0x3000F000;
	}
}