using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Net;
using System.Text;
using System.Threading;
using System.Text.RegularExpressions;
using System.Windows.Forms;

using Boon.Controls.Browsers;

using Boon.Collections;
using Boon.Net;
using Boon.IO.File;
using HttpService.API;
using HttpService.API.Request;
using Boon.Forms.Dialog;

namespace Boon.Forms
{
    public partial class MainForm : Form
    {
        #region contextMenuStrip100֘A(uEŨ^ủENbN)

        /// <summary>
        /// 
        /// </summary>
        private int context100TargetIndex { get { return this.tabBrowser.TbContextMenuTargetIndex; } }

        /// <summary>
        /// u^uvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem101_CloseTab_Click(object sender, EventArgs e)
        {
            this.tabBrowser.TbClose(this.context100TargetIndex);
        }

        /// <summary>
        /// uׂẴ^uvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem102_CloseAllTabs_Click(object sender, EventArgs e)
        {
            this.tabBrowser.TbClear(false);
        }

        /// <summary>
        /// uV^uJvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem103_OpenNewTab_Click(object sender, EventArgs e)
        {
            this.tabBrowser.TbOpenNewTab("about:blank");
        }

        /// <summary>
        /// uXVvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem104_Refresh_Click(object sender, EventArgs e)
        {
            this.tabBrowser.TbRefresh(this.context100TargetIndex);
        }

        /// <summary>
        /// uׂẴbN^uXVvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem105_RefreshAllLockedTabs_Click(object sender, EventArgs e)
        {
            this.tabBrowser.TbRefreshAll(true);
        }

        /// <summary>
        /// uׂẴ^uXVvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem106_RefreshAllTabs_Click(object sender, EventArgs e)
        {
            int tooMuchTabs = 6;
            if (this.tabBrowser.TbTabCount >= tooMuchTabs)
            {
                if (MessageBox.Show("\̃^uxɍXV悤ƂĂ܂B\n̑̓T[o[ɑ傫ȕׂSz܂B\n\n{Ɏs܂H"
                , "\ׂ̂Ẵ^u̍XV", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning)
                    == DialogResult.Cancel)
                {
                    return;
                }
            }
            this.tabBrowser.TbRefreshAll(false);
        }

        /// <summary>
        /// ũ^ubNvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem107_LockThisTab_Click(object sender, EventArgs e)
        {
            this.tabBrowser.TbSetIsLocked(
                this.context100TargetIndex,
                this.tabBrowser.TbGetIsLocked(this.context100TargetIndex));
        }

        /// <summary>
        /// u^CgURLRs[vIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem108_CopyTitleAndUrl_Click(object sender, EventArgs e)
        {
            if (this.tabBrowser.InRange(this.context100TargetIndex))
            {
                Clipboard.SetText(
                    this.tabBrowser.TbGetControl(this.context100TargetIndex).DisplayTitle
                    + "\n" +
                    this.tabBrowser.TbGetControl(this.context100TargetIndex).DisplayUrl);
            }
        }

        /// <summary>
        /// u^CgRs[vIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem109_CopyTitle_Click(object sender, EventArgs e)
        {
            string s = this.tabBrowser.TbGetTitle(this.context100TargetIndex);
            if (s == String.Empty)
            {
                Clipboard.SetText(this.tabBrowser.TbGetControl(this.context100TargetIndex).DisplayTitle);
            }
        }

        /// <summary>
        /// uURLRs[vIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem110_CopyUrl_Click(object sender, EventArgs e)
        {
            if (this.tabBrowser.InRange(this.context100TargetIndex))
            {
                Clipboard.SetText(this.tabBrowser.TbGetControl(this.context100TargetIndex).DisplayUrl);
            }
        }

        #endregion

        #region contextMenuStrip200֘A(̃c[tH_̉ENbN)

        /// <summary>
        /// u_E[hXg폜vIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem201_DeleteDownloadList_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// uTutH_쐬vIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem202_CreateSubFolder_Click(object sender, EventArgs e)
        {
            Boon.Forms.Dialog.CreateFolderDialog dialog = new Boon.Forms.Dialog.CreateFolderDialog();
            dialog.setFolderData(this.saveFolderTreeView, (string)(this.saveFolderTreeView.SelectedNode.Tag));
            dialog.Show(this);
        }

        /// <summary>
        /// uOύXvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem203_ChangeName_Click(object sender, EventArgs e)
        {
            TreeNode selectedNode = this.saveFolderTreeView.SelectedNode;
            if (selectedNode == null) return;

            selectedNode.BeginEdit();
        }

        /// <summary>
        /// utH_폜vIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem204_DeleteFolder_Click(object sender, EventArgs e)
        {
            TreeNode selectedNode = this.saveFolderTreeView.SelectedNode;
            if ( (selectedNode == null) || (selectedNode.Parent == null) )
            {
                MessageBox.Show("폜ł܂B");
                return;
            }

            DirectoryInfo di = new DirectoryInfo(selectedNode.Tag.ToString());
            //di.Delete(true);
            Debug.WriteLine(selectedNode.Tag.ToString() + "폜܂B(AeXg҂j");

            
        }

        /// <summary>
        /// uGNXv[ŊJvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem205_OpenWithExplorer_Click(object sender, EventArgs e)
        {
            TreeNode selectedNode = this.saveFolderTreeView.SelectedNode;

            if (selectedNode == null) return;

            Process.Start("EXPLORER.EXE", @"/e, " + selectedNode.Tag.ToString());
        }

        #endregion

        #region contextMenuStrip201֘A(̃c[tH_ŁA_E[hỈENbN)

        #endregion

        #region contextMenuStrip300֘A(_E[hListView̉ENbN)

        /// <summary>
        /// uĐvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem301_PlayMovie_Click(object sender, EventArgs e)
        {
            VideoFileData vfd = (VideoFileData)this.downloadListView.SelectedItems[0].Tag;

            if (vfd.videoFileStatus != VideoFileData.DOWNLOAD_COMPLETED)
            {
                MessageBox.Show("t@C̃_E[hĂ܂B");
                return;
            }

            if (!File.Exists(vfd.videoFilePath))
            {
                MessageBox.Show(vfd.videoFilePath + "݂܂B");
                return;
            }

            MessageBox.Show(vfd.videoFilePath + "Đ܂B");
        }

        /// <summary>
        /// uuEUŌJvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem302_OpenOriginalMovieByBrowser_Click(object sender, EventArgs e)
        {
            VideoFileData vfd = (VideoFileData)this.downloadListView.SelectedItems[0].Tag;
            String videoID = vfd.videoID;

            MessageBox.Show(videoID + "uEUŊJ܂B\nURL:" + BoonCommon.Url_NicoRoot + "/watch/" + videoID);
        }

        /// <summary>
        /// uBOON SUTAZIOŌJvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem303_OpenOriginalMovieByBoon_Click(object sender, EventArgs e)
        {
            VideoFileData vfd = (VideoFileData)this.downloadListView.SelectedItems[0].Tag;
            String videoID = vfd.videoID;

            MessageBox.Show(videoID + "vC[ŊJ܂B\nURL:" + BoonCommon.Url_NicoRoot + "/watch/" + videoID);
        }

        /// <summary>
        /// ut@C폜vIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem304_DeleteFile_Click(object sender, EventArgs e)
        {
            List<ListViewItem> selectedListViewItem = this.getSelectedListViewItems();

            foreach (ListViewItem i in selectedListViewItem)
            {
                VideoFileData vfd = (VideoFileData)i.Tag;
                if ((vfd.videoFileStatus == VideoFileData.DOWNLOAD_PROCESSING) || (vfd.videoFileStatus == VideoFileData.DOWNLOAD_WAITING))
                {
                    BoonDownloadManager.Instance.stopDownload(vfd.videoID);
                }

                if (File.Exists(vfd.videoFilePath))
                {
                    File.Delete(vfd.videoFilePath);
                }

                if (File.Exists(vfd.commentFilePath))
                {
                    File.Delete(vfd.commentFilePath);
                }

                i.Remove();
            }

        }

        /// <summary>
        /// uXgvIۂ̃CxgłB
        /// ̃t@C̍폜͍s܂B
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem305_DeleteFromDownloadList_Click(object sender, EventArgs e)
        {
            List<ListViewItem> selectedListViewItem = this.getSelectedListViewItems();

            foreach (ListViewItem i in selectedListViewItem)
            {
                VideoFileData vfd = (VideoFileData)i.Tag;
                if ((vfd.videoFileStatus == VideoFileData.DOWNLOAD_PROCESSING) || (vfd.videoFileStatus == VideoFileData.DOWNLOAD_WAITING))
                {
                    BoonDownloadManager.Instance.stopDownload(vfd.videoID);
                }

                i.Remove();
            }
        }

        /// <summary>
        /// uXg̑SvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem306_DeleteAllFromDownloadList_Click(object sender, EventArgs e)
        {
            this.downloadListView.Items.Clear();
        }

        /// <summary>
        /// u_E[h̍ĎsvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem307_RetryDownload_Click(object sender, EventArgs e)
        {
            List<ListViewItem> selectedListViewItem = this.getSelectedListViewItems();

            foreach (ListViewItem i in selectedListViewItem)
            {
                VideoFileData vfd = (VideoFileData)i.Tag;
                BoonDownloadManager.addReservation(vfd.videoID, i, false);
            }

        }

        /// <summary>
        /// u悾_E[hĎsvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem308_RetryDownloadOnlyMovieFile_Click(object sender, EventArgs e)
        {
            List<ListViewItem> selectedListViewItem = this.getSelectedListViewItems();

            foreach (ListViewItem i in selectedListViewItem)
            {
                VideoFileData vfd = (VideoFileData)i.Tag;
                BoonDownloadManager.addReservation(vfd.videoID, i, true);
            }

        }

        /// <summary>
        /// u^CgURLRs[vIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem309_CopyTitleAndUrl_Click(object sender, EventArgs e)
        {
            List<ListViewItem> list = this.getSelectedListViewItems();

            if (list.Count == 0)
            {
                return;
            }

            StringBuilder sb = new StringBuilder();

            foreach (ListViewItem lvi in list)
            {
                VideoFileData vfd = (VideoFileData)lvi.Tag;
                sb.Append(vfd.videoTitle + " " + vfd.fileUrl + "\n");
            }

            if (sb.ToString().EndsWith("\n"))
            {
                sb.Remove(sb.Length - 1, 1);
            }

            Clipboard.SetText(sb.ToString());

        }

        /// <summary>
        /// u^CgRs[vIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem310_CopyTitle_Click(object sender, EventArgs e)
        {
            List<ListViewItem> list = this.getSelectedListViewItems();

            if (list.Count == 0)
            {
                return;
            }

            StringBuilder sb = new StringBuilder();

            foreach (ListViewItem lvi in list)
            {
                sb.Append(((VideoFileData)lvi.Tag).videoTitle + "\n");
            }

            if (sb.ToString().EndsWith("\n"))
            {
                sb.Remove(sb.Length - 1, 1);
            }

            Clipboard.SetText(sb.ToString());
        }

        /// <summary>
        /// uURLRs[vIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem311_CopyUrl_Click(object sender, EventArgs e)
        {
            List<ListViewItem> list = this.getSelectedListViewItems();

            if (list.Count == 0)
            {
                return;
            }

            StringBuilder sb = new StringBuilder();

            foreach (ListViewItem lvi in list)
            {
                sb.Append(((VideoFileData)lvi.Tag).fileUrl + "\n");
            }

            if (sb.ToString().EndsWith("\n"))
            {
                sb.Remove(sb.Length - 1, 1);
            }

            Clipboard.SetText(sb.ToString());
        }

        /// <summary>
        /// ut@CւčĐvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem312_PlayWithOtherMovieFile_Click(object sender, EventArgs e)
        {
            MessageBox.Show("ut@CւčĐvF(vȂ)");
        }

        /// <summary>
        /// uRgt@CւčĐvIۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void toolStripMenuItem313_PlayWithOtherCommentFile_Click(object sender, EventArgs e)
        {
            MessageBox.Show("uRgt@CւčĐvF(vȂ)");
        }

        /// <summary>
        /// ReLXgj[Jꂽۂ̃CxgłB
        /// ListViewőIĂȂƂ̓LZ܂B
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێCancelEventArgsIuWFNg</param>
        private void contextMenuStrip300_ForDownloadList_Opening(object sender, CancelEventArgs e)
        {
            int listKind = this.getListKind(this.saveFolderTreeView.SelectedNode);

            switch (listKind)
            {
                case BoonDefine.DOWNLOAD_FOLDER_INDEX:
                    if (this.downloadListView.SelectedIndices.Count == 0) e.Cancel = true;
                    break;

                case BoonDefine.SAVE_FOLDER_INDEX:
                    if (this.saveFolderListView.SelectedIndices.Count == 0) e.Cancel = true;
                    break;

                case BoonDefine.SEARCH_FILES_INDEX:
                    if (this.saveFolderListView.SelectedIndices.Count == 0) e.Cancel = true;
                    break;

                default:
                    break;
            }
        }

        /// <summary>
        /// downloadListViewőIĂListViewItem̈ꗗ擾܂B
        /// </summary>
        /// <returns>IĂListViewItemێListIuWFNg</returns>
        private List<ListViewItem> getSelectedListViewItems()
        {
            List<ListViewItem> result = new List<ListViewItem>();

            ListView.SelectedListViewItemCollection list = this.downloadListView.SelectedItems;

            foreach (ListViewItem lvi in list)
            {
                result.Add(lvi);
            }

            return (result);
        }

        #endregion

        #region contextMenuStrip400֘A(_E[hListViewŁAt@CỈENbN)

        /// <summary>
        /// ReLXgj[Jꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێCancelEventArgsIuWFNg</param>
        private void contextMenuStrip400_ForSaveFolderList_Opening(object sender, CancelEventArgs e)
        {

        }



        #endregion

    }
}
