using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;
using mshtml;
using System.Security;

namespace ProjectBoon.Win32
{
	[ComImport, Guid("00000122-0000-0000-C000-000000000046"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IOleDropTarget
	{
		[PreserveSig]
		int OleDragEnter([In, MarshalAs(UnmanagedType.Interface)] object pDataObj, [In, MarshalAs(UnmanagedType.U4)] int grfKeyState, [In, MarshalAs(UnmanagedType.U8)] long pt, [In, Out] ref int pdwEffect);
		[PreserveSig]
		int OleDragOver([In, MarshalAs(UnmanagedType.U4)] int grfKeyState, [In, MarshalAs(UnmanagedType.U8)] long pt, [In, Out] ref int pdwEffect);
		[PreserveSig]
		int OleDragLeave();
		[PreserveSig]
		int OleDrop([In, MarshalAs(UnmanagedType.Interface)] object pDataObj, [In, MarshalAs(UnmanagedType.U4)] int grfKeyState, [In, MarshalAs(UnmanagedType.U8)] long pt, [In, Out] ref int pdwEffect);
	}


	[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("00000118-0000-0000-C000-000000000046")]
	public interface IOleClientSite_HRES
	{
		[PreserveSig]
		int SaveObject();
		[PreserveSig]
		int GetMoniker([In, MarshalAs(UnmanagedType.U4)] int dwAssign, [In, MarshalAs(UnmanagedType.U4)] int dwWhichMoniker, [MarshalAs(UnmanagedType.Interface)] out object moniker);
		[PreserveSig]
		int GetContainer(out IOleContainer container);
		[PreserveSig]
		int ShowObject();
		[PreserveSig]
		int OnShowWindow(int fShow);
		[PreserveSig]
		int RequestNewObjectLayout();
	}

	[ComImport, Guid("00000118-0000-0000-C000-000000000046"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IOleClientSite
	{
		void SaveObject();
		void GetMoniker(uint dwAssign, uint dwWhichMoniker, ref object ppmk);
		void GetContainer(ref object ppContainer);
		void ShowObject();
		void OnShowWindow(bool fShow);
		void RequestNewObjectLayout();
	}

	[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("B196B289-BAB4-101A-B69C-00AA00341D07")]
	public interface IOleControlSite
	{
		[PreserveSig]
		int OnControlInfoChanged();
		[PreserveSig]
		int LockInPlaceActive(int fLock);
		[PreserveSig]
		int GetExtendedControl([MarshalAs(UnmanagedType.IDispatch)] out object ppDisp);
		[PreserveSig]
		int TransformCoords([In, Out] _POINTL pPtlHimetric, [In, Out] tagPOINTF pPtfContainer, [In, MarshalAs(UnmanagedType.U4)] int dwFlags);
		[PreserveSig]
		int TranslateAccelerator([In] ref MSG pMsg, [In, MarshalAs(UnmanagedType.U4)] int grfModifiers);
		[PreserveSig]
		int OnFocus(int fGotFocus);
		[PreserveSig]
		int ShowPropertyFrame();
	}

	[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("0000011B-0000-0000-C000-000000000046")]
	public interface IOleContainer
	{
		[PreserveSig]
		int ParseDisplayName(
			[In, MarshalAs(UnmanagedType.Interface)] object pbc,
			[In, MarshalAs(UnmanagedType.BStr)] string pszDisplayName,
			[Out, MarshalAs(UnmanagedType.LPArray)] int[] pchEaten,
			[Out, MarshalAs(UnmanagedType.LPArray)] object[] ppmkOut);
		[PreserveSig]
		int EnumObjects(
			[In, MarshalAs(UnmanagedType.U4)] int grfFlags,
			[Out, MarshalAs(UnmanagedType.LPArray)] object[] ppenum);
		[PreserveSig]
		int LockContainer(bool fLock);
	}



	[ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("9BFBBC02-EFF1-101A-84ED-00AA00341D07")]
	public interface IPropertyNotifySink
	{
		void OnChanged(int dispID);
		[PreserveSig]
		int OnRequestEdit(int dispID);
	}

	[ComImport, Guid("742B0E01-14E6-101B-914E-00AA00300CAB"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface ISimpleFrameSite
	{
		[PreserveSig]
		int PreMessageFilter(IntPtr hwnd, [In, MarshalAs(UnmanagedType.U4)] int msg, IntPtr wp, IntPtr lp, [In, Out] ref IntPtr plResult, [In, Out, MarshalAs(UnmanagedType.U4)] ref int pdwCookie);
		[PreserveSig]
		int PostMessageFilter(IntPtr hwnd, [In, MarshalAs(UnmanagedType.U4)] int msg, IntPtr wp, IntPtr lp, [In, Out] ref IntPtr plResult, [In, MarshalAs(UnmanagedType.U4)] int dwCookie);
	}
}
