using System;
using System.Runtime.InteropServices;
using System.Text;

namespace Boon.Win32
{
	internal static class Wininet
	{

		#region Methods

		/// <summary>
		/// IẼLbVw肵URL̃t@CTāÃLbVt@C̃pXԂ܂B
		/// sString.EmptyԂ܂B
		/// </summary>
		/// <param name="url"></param>
		/// <returns></returns>
		public static string FindCachePath(string url)
		{
			INTERNET_CACHE_ENTRY_INFOA cacheEntry;
			IntPtr cacheEntryBuf = IntPtr.Zero;
			const int ERROR_NO_MORE_ITEMS = 259;
			int ceiBufSizeInit = 0;
			int ceiBufSize = 0;
			IntPtr handle = IntPtr.Zero;
			bool retval = false;
			string result = String.Empty;

			handle = FindFirstUrlCacheEntry(null, IntPtr.Zero, ref ceiBufSizeInit);
			if(handle != IntPtr.Zero && ERROR_NO_MORE_ITEMS == Marshal.GetLastWin32Error())
			{
				return String.Empty;
			}

			ceiBufSize = ceiBufSizeInit;
			cacheEntryBuf = Marshal.AllocHGlobal(ceiBufSize);
			handle = FindFirstUrlCacheEntry(null, cacheEntryBuf, ref ceiBufSizeInit);

			while(true)
			{
				cacheEntry = (INTERNET_CACHE_ENTRY_INFOA)Marshal.PtrToStructure(cacheEntryBuf, typeof(INTERNET_CACHE_ENTRY_INFOA));
				ceiBufSizeInit = ceiBufSize;
				string sUrl = Marshal.PtrToStringAnsi(cacheEntry.lpszSourceUrlName);
				string sFile = Marshal.PtrToStringAnsi(cacheEntry.lpszLocalFileName);
				if(sUrl.Equals(url))
				{
					result = sFile;
					break;
				}

				retval = FindNextUrlCacheEntry(handle, cacheEntryBuf, ref ceiBufSizeInit);
				if(!retval && ERROR_NO_MORE_ITEMS == Marshal.GetLastWin32Error())
				{
					break;
				}
				if(!retval && ceiBufSizeInit > ceiBufSize)
				{
					ceiBufSize = ceiBufSizeInit;
					cacheEntryBuf = Marshal.ReAllocHGlobal(cacheEntryBuf, (IntPtr)ceiBufSize);
					retval = FindNextUrlCacheEntry(handle, cacheEntryBuf, ref ceiBufSizeInit);
				}
			}

			return result;
		}

		/// <summary>
		/// w肵URLɎgpCookie-HeaderԂ܂B
		/// ԂCookie-HeadeŕACookieContainer.SetCookieṕu,v؂łB
		/// </summary>
		/// <param name="url"></param>
		/// <returns></returns>
		public static string GetIECookie(string url)
		{
			// StringBuilder󔒕Ŗ߂āATCY4096oCgŊmۂB
			// ʓICookie̍őTCY4096oCg炵̂ŁA4096ɂB
			StringBuilder cookieData = new StringBuilder(new String(' ', 4096), 4096);

			// InternetGetCookieŗpATCYmہB
			uint size = (uint)cookieData.Length;

			// IECookieWin32 API𗘗pĎ擾B
			// url = FQDN, null, 擾ėIECookieϐ
			// 擾CookĩTCYB API߂Ăɂ́A擾CookiẽTCYĂ
			// w肵sizeۂɑ݂Cookie̗eʂ菬ꍇA擾ėCookie
			// sizeŎw肵Ő؂B̏ꍇA߂Ăsize̐l͎ۂɑ݂CookiẽTCY
			// Ė߂ĂB
			bool b = InternetGetCookie(url, null, cookieData, ref size);

			// Ô߁A擾ėCookiẽTCY4096ȏł͂Ȃ𒲂ׂ
			// 4096ȏゾꍇ́Asizew肵āAēxInternetGetCookies
			if(size > 4096)
			{
				// StringBuilder̗eʂsize܂ōL
				cookieData.Capacity = (int)size;
				// ēxIECookie擾
				InternetGetCookie(url, null, cookieData, ref size);
			}

			// ėCookie;ŋ؂ĂׁA
			// CookieContainerŗpł悤ɁA;,֒uĂB
			return cookieData.ToString().Replace(";", ",");
		}

		#endregion

		#region extern wininet.dll for cache

		// For PInvoke: Initiates the enumeration of the cache groups in the Internet cache
		[DllImport(@"wininet",
			SetLastError = true,
			CharSet = CharSet.Auto,
			EntryPoint = "FindFirstUrlCacheGroup",
			CallingConvention = CallingConvention.StdCall)]
		public static extern IntPtr FindFirstUrlCacheGroup(
			int dwFlags,
			int dwFilter,
			IntPtr lpSearchCondition,
			int dwSearchCondition,
			ref long lpGroupId,
			IntPtr lpReserved);

		// For PInvoke: Retrieves the next cache group in a cache group enumeration
		[DllImport(@"wininet",
			SetLastError = true,
			CharSet = CharSet.Auto,
			EntryPoint = "FindNextUrlCacheGroup",
			CallingConvention = CallingConvention.StdCall)]
		public static extern bool FindNextUrlCacheGroup(
			IntPtr hFind,
			ref long lpGroupId,
			IntPtr lpReserved);

		// For PInvoke: Releases the specified GROUPID and any associated state in the cache index file
		[DllImport(@"wininet",
			SetLastError = true,
			CharSet = CharSet.Auto,
			EntryPoint = "DeleteUrlCacheGroup",
			CallingConvention = CallingConvention.StdCall)]
		public static extern bool DeleteUrlCacheGroup(
			long GroupId,
			int dwFlags,
			IntPtr lpReserved);

		// For PInvoke: Begins the enumeration of the Internet cache
		[DllImport(@"wininet",
			SetLastError = true,
			CharSet = CharSet.Auto,
			EntryPoint = "FindFirstUrlCacheEntryA",
			CallingConvention = CallingConvention.StdCall)]
		public static extern IntPtr FindFirstUrlCacheEntry(
			[MarshalAs(UnmanagedType.LPTStr)] string lpszUrlSearchPattern,
			IntPtr lpFirstCacheEntryInfo,
			ref int lpdwFirstCacheEntryInfoBufferSize);

		// For PInvoke: Retrieves the next entry in the Internet cache
		[DllImport(@"wininet",
			SetLastError = true,
			CharSet = CharSet.Auto,
			EntryPoint = "FindNextUrlCacheEntryA",
			CallingConvention = CallingConvention.StdCall)]
		public static extern bool FindNextUrlCacheEntry(
			IntPtr hFind,
			IntPtr lpNextCacheEntryInfo,
			ref int lpdwNextCacheEntryInfoBufferSize);

		// For PInvoke: Removes the file that is associated with the source name from the cache, if the file exists
		[DllImport(@"wininet",
			SetLastError = true,
			CharSet = CharSet.Auto,
			EntryPoint = "DeleteUrlCacheEntryA",
			CallingConvention = CallingConvention.StdCall)]
		public static extern bool DeleteUrlCacheEntry(
			IntPtr lpszUrlName);


		#endregion


		#region extern wininet.dll IE Cookie


		[DllImport("wininet", EntryPoint = "InternetGetCookie")]
		private extern static bool InternetGetCookie(
			string lpszUrl,
			string lpszCookieName,
			StringBuilder lpCookieData,
			ref uint lpdwSize
		);

		[DllImport("wininet.dll", EntryPoint = "InternetSetCookie")]
		private extern static bool InternetSetCookie(
			string lpszUrl,
			string lpszCookieName,
			string lpszCookieData
		);

		#endregion

		#region

		//[DllImport("wininet.dll", SetLastError = true)]
		//private static extern bool InternetSetOption(IntPtr hInternet,
		//int dwOption,
		//IntPtr lpBuffer,
		//int lpdwBufferLength);

		//private const uint INTERNET_PER_CONN_PROXY_SERVER = 2;
		//private const uint INTERNET_OPEN_TYPE_PROXY = 3;

		//private const uint INTERNET_OPTION_REFRESH = 37;
		//private const uint INTERNET_OPTION_PROXY = 38;
		//private const uint INTERNET_OPTION_SETTINGS_CHANGED = 39;
		//private const uint INTERNET_OPTION_END_BROWSER_SESSION = 42;
		//private const uint INTERNET_OPTION_PER_CONNECTION_OPTION = 75;


		//[StructLayout(LayoutKind.Sequential)]
		//public struct INTERNET_PER_CONN_PROXY_OPTION
		//{
		//    public IntPtr plzValue;
		//}
		//[StructLayout(LayoutKind.Sequential)]
		//public struct INTERNET_PER_CONN_PROXY_OPTION_LIST
		//{
		//    public uint dwSize;
		//    public StringBuilder pszConnection;
		//    public uint dwOptionCount;
		//    public uint dwOptionError;
		//    public INTERNET_PER_CONN_PROXY_OPTION[] pOptions;
		//}

		//public string InternetSetProxy(string proxyurl, string proxybipass)
		//{
		//    INTERNET_PER_CONN_PROXY_OPTION_LIST list;
		//    INTERNET_PER_CONN_PROXY_OPTION ipcpo;
		//    ipcpo = null;
		//    list.dwSize = sizeof(INTERNET_PER_CONN_PROXY_OPTION_LIST);
		//    list.pszConnection = null;
		//    list.dwOptionError = -1;
		//    list.pOptions = new INTERNET_PER_CONN_PROXY_OPTION[] { ipcpo };
		//    list.dwOptionCount = list.pOptions.Length;

		//}

		#endregion

		// For PInvoke: Contains information about an entry in the Internet cache
		[StructLayout(LayoutKind.Explicit, Size = 80)]
		public struct INTERNET_CACHE_ENTRY_INFOA
		{
			[FieldOffset(0)]
			public uint dwStructSize;
			[FieldOffset(4)]
			public IntPtr lpszSourceUrlName;
			[FieldOffset(8)]
			public IntPtr lpszLocalFileName;
			[FieldOffset(12)]
			public uint CacheEntryType;
			[FieldOffset(16)]
			public uint dwUseCount;
			[FieldOffset(20)]
			public uint dwHitRate;
			[FieldOffset(24)]
			public uint dwSizeLow;
			[FieldOffset(28)]
			public uint dwSizeHigh;
			[FieldOffset(32)]
			public System.Runtime.InteropServices.ComTypes.FILETIME LastModifiedTime;
			[FieldOffset(40)]
			public System.Runtime.InteropServices.ComTypes.FILETIME ExpireTime;
			[FieldOffset(48)]
			public System.Runtime.InteropServices.ComTypes.FILETIME LastAccessTime;
			[FieldOffset(56)]
			public System.Runtime.InteropServices.ComTypes.FILETIME LastSyncTime;
			[FieldOffset(64)]
			public IntPtr lpHeaderInfo;
			[FieldOffset(68)]
			public uint dwHeaderInfoSize;
			[FieldOffset(72)]
			public IntPtr lpszFileExtension;
			[FieldOffset(76)]
			public uint dwReserved;
			[FieldOffset(76)]
			public uint dwExemptDelta;
		}
	}

}
