%-*- Prolog -*-
% Library of fanqies

% fanqie spelling FQ := fq(Char, Fanqie)
%    fanqie spelling FQ := fq(Char, [Fanqie+/,])
% fanqie sequence FSeq := [FQ*/,]
% fanqie separation FSep := [FSeq*/,]

:- module(fanqie, [utongyong/3, uhuyong/3, udiyong/3,
		   ltongyong/3, lhuyong/3, ldiyong/3]).

% 同用
% tongyong(+FQ1, +FQ2, -RFQ)
% Upper  fq(X, AB), fq(Y, AC) => [X, A, Y]
% Lower  fq(X, BA), fq(Y, CA) => [X, A, Y]
utongyong(fq(X,F1), fq(Y,F2), [X, A, Y]) :-
    atom_chars(F1, [A, _]),
    atom_chars(F2, [A, _]), !.
ltongyong(fq(X,F1), fq(Y,F2), [X, A, Y]) :-
    atom_chars(F1, [_, A]),
    atom_chars(F2, [_, A]), !.

% 互用
% huyong(+FQ1, +FQ2, -RFQ)
% Upper  fq(X, YB), fq(Y, XC) => [X, Y]
% Lower  fq(X, BY), fq(Y, CX) => [X, Y]
uhuyong(fq(X,F1), fq(Y,F2), [X, Y]) :-
    atom_chars(F1, [Y, _]),
    atom_chars(F2, [X, _]), !.
lhuyong(fq(X,F1), fq(Y,F2), [X, Y]) :-
    atom_chars(F1, [_, Y]),
    atom_chars(F2, [_, X]), !.

% 遞用
% diyong(+FQ1, +FQ2, -RFQ)
% Upper  fq(X, YA), fq(Y, ZB) => [X, Y, Z]
% Lower  fq(X, AY), fq(Y, BZ) => [X, Y, Z]
udiyong(fq(X,F1), fq(Y,F2), [X, Y, Z]) :-
    atom_chars(F1, [Y, _]),
    atom_chars(F2, [Z, _]), !.
ldiyong(fq(X,F1), fq(Y,F2), [X, Y, Z]) :-
    atom_chars(F1, [_, Y]),
    atom_chars(F2, [_, Z]), !.
