%-*- Prolog -*-
% Tests for emclib

:- module(test_emclib, [list_chars/0, test_mc/0,
			test_initial/0, test_final/0, test_tone/0,
			test_cat/0]).
:- use_module(emclib, [mc_concat/4, mc_initial/2, mc_final/2, mc_tone/2,
		       trad_cat/2, ph_cat/2]).
:- use_module(bsocr, [char/6]).
%:- use_module(initials, [initial/3, initial/1, palatal/1]).

list_chars :-
    char(Z, P, MC, I, F, T),
    countup(chars),
    count(chars, N),
    writef("[%w] %w %w %w %w %w %w\n", [N, Z, P, MC, I, F, T]),
    fail.
list_chars :- true.

test_mc :-
    char(Z, P, MC, I, F, T),
    countup(mc),
    count(mc, N),
    mc_concat(I, F, T, MC1),
    MC \== MC1,
    writef("[%w] %w %w %w %w %w %w: ", [N, Z, P, MC, I, F, T]),
    writef("MC(%w)\n", [MC1]),
    fail.
test_mc :- true.

test_initial :-
    char(Z, P, MC, I, F, T),
    countup(initial),
    count(initial, N),
    mc_initial(MC, I1),
    I \== I1, !,
    writef("[%w] %w %w %w %w %w %w: ", [N, Z, P, MC, I, F, T]),
    writef("I(%w)\n", [I1]),
    fail.
test_initial :- true.

test_final :-
    char(Z, P, MC, I, F, T),
    countup(final),
    count(final, N),
    mc_final(MC, F1),
    F \== F1, !,
    writef("[%w] %w %w %w %w %w %w: ", [N, Z, P, MC, I, F, T]),
    writef("F(%w)\n", [F1]),
    fail.
test_final :- true.

test_tone :-
    char(Z, P, MC, I, F, T),
    countup(tone),
    count(tone, N),
    mc_tone(MC, T1),
    T \== T1, !,
    writef("[%w] %w %w %w %w %w %w: ", [N, Z, P, MC, I, F, T]),
    writef("T(%w)\n", [T1]),
    fail.
test_tone :- true.

test_cat :-
    trad_cat('tuwng', Cat1),
    writef("tuwng: %w\n", [Cat1]), % 端東1平
    trad_cat('tuwngX', Cat2),
    writef("tuwngX: %w\n", [Cat2]), % 端董1上
    trad_cat('tuwngH', Cat3),
    writef("tuwngH: %w\n", [Cat3]),% 端送1去
    trad_cat('tuwk', Cat4),
    writef("tuwk: %w\n", [Cat4]), % 端屋1入
    trad_cat('tsyowng', Cat5),
    writef("tsyowng: %w\n", [Cat5]). % 端3平

%----- Utility -----
countup(Name) :-
    retract(count(Name, N)), !,
    M is N + 1,
    asserta(count(Name, M)).
countup(Name) :- asserta(count(Name, 0)), !.
