/*
# eosStarFile.h : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : eosStarFile.h 
# Attention
#   $Loccker$
#  	$State$ 
#
*/
/* $Log$ */
#ifndef EOS_STAR_FILE
#define EOS_STAR_FILE

#include <stdio.h>

/* constant begin */


/* constant end */

/* struct begin */
typedef struct eosStarFileData {
    char* key;
    char**  valueS;
    double* valueR;
    int*    valueI;
} eosStarFileData;

typedef struct eosStgrFileDataBlock {
    char* dataBlockName;

    int   numDataItem;
    eosStarFileData* data;

    int numLoopKey;
    int numLoopData;
    eosStarFileData* loop;
} eosStgrFileDataBlock;

typedef struct eosStarFile {
    int numDataBlock;
    eosStgrFileDataBlock*  block;
} eosStarFile;

/* struct end */

#ifdef __cplusplus
extern "C" {
#endif

/* prototype begin */
void eosStarFileWrite(FILE* fpt, eosStarFile* star, int mode);

void eosStarFileDataSizeSet(eosStarFile* star, int mode);

void eosStarFileDataKeySet(eosStarFile* star, char* key, int index, int mode);
void eosStarFileDataValueSSet(eosStarFile* star, char* key, char* value, int mode);
void eosStarFileDataValueRSet(eosStarFile* star, char* key, double value, int mode);
void eosStarFileDataValueISet(eosStarFile* star, char* key, int    value, int mode);

void eosStarFileLoopDataKeySet(eosStarFile* star, int index, int mode);
void eosStarFileLoopDataValueSSet(eosStarFile* star, char* key, char**  value, int mode);
void eosStarFileLoopDataValueRSet(eosStarFile* star, char* key, double* value, int mode);
void eosStarFileLoopDataValueISet(eosStarFile* star, char* key, int*    value, int mode);

// esoStarFileRead.c
void eosStarFileRead (FILE* fpt, eosStarFile* star, int mode);
void eosStarFileDataSizeGet(FILE* fpt, eosStarFile* star, int mode);
void eosStarFileRead0 (FILE* fpt, eosStarFile* star, int mode);

// data
char* eosStarFileDataGetStringP(eosStarFile* star, char* key, int mode);
void eosStarFileDataGetString(eosStarFile* star, char* key, char** value, int mode);

double eosStarFileDataGetRealP(eosStarFile* star, char* key, int mode);
void eosStarFileDataGetReal(eosStarFile* star, char* key, double* value, int mode);

int eosStarFileDataGetInterger(eosStarFile* star, char* key, int mode);
void eosStarFilDataGetInterger(eosStarFile* star, char* key, int* value, int mode);

// Loop
char** eosStarFileLoopDataGetStringP(eosStarFile* star, char* key, int mode);
void eosStarFileLoopDataGetString(eosStarFile* star, char* key, char*** value, int mode);

double* eosStarFileLoopDataGetRealP(eosStarFile* star, char* key, int mode);
void eosStarFileLoopDataGetReal(eosStarFile* star, char* key, double** value, int mode);

int* eosStarFileLoopDataGetIntergerP(eosStarFile* star, char* key, int mode);
void eosStarFileLoopDataGetInterger(eosStarFile* star, char* key, int** value, int mode);

/* prototype end */

#ifdef __cplusplus
};
#endif

#endif  /* EOS_STAR_FILE */ 
