# encoding: UTF-8
# This file is auto-generated from the current state of the database. Instead
# of editing this file, please use the migrations feature of Active Record to
# incrementally modify your database, and then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your
# database schema. If you need to create the application database on another
# system, you should be using db:schema:load, not running all the migrations
# from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended to check this file into your version control system.

ActiveRecord::Schema.define(:version => 20120226115603) do

  create_table "classifications", :force => true do |t|
    t.integer  "organ_id"
    t.string   "disease"
    t.datetime "created_at", :null => false
    t.datetime "updated_at", :null => false
  end

  add_index "classifications", ["organ_id"], :name => "index_classifications_on_organ_id"

  create_table "clinicians", :force => true do |t|
    t.string   "name"
    t.datetime "created_at", :null => false
    t.datetime "updated_at", :null => false
  end

  create_table "clinicians_histologies", :id => false, :force => true do |t|
    t.integer "Clinician_id"
    t.integer "Histology_id"
  end

  add_index "clinicians_histologies", ["Clinician_id"], :name => "index_clinicians_histologies_on_Clinician_id"
  add_index "clinicians_histologies", ["Histology_id"], :name => "index_clinicians_histologies_on_Histology_id"

  create_table "departments", :force => true do |t|
    t.string   "name"
    t.datetime "created_at", :null => false
    t.datetime "updated_at", :null => false
  end

  create_table "departments_histologies", :id => false, :force => true do |t|
    t.integer "department_id"
    t.integer "histology_id"
  end

  add_index "departments_histologies", ["department_id"], :name => "index_departments_histologies_on_department_id"
  add_index "departments_histologies", ["histology_id"], :name => "index_departments_histologies_on_histology_id"

  create_table "histologies", :force => true do |t|
    t.integer  "number"
    t.integer  "patient_id"
    t.date     "operation_date"
    t.integer  "department_id"
    t.text     "clinical_diagnosis"
    t.text     "clinical_summary"
    t.string   "purpose"
    t.datetime "created_at",         :null => false
    t.datetime "updated_at",         :null => false
  end

  add_index "histologies", ["department_id"], :name => "index_histologies_on_department_id"
  add_index "histologies", ["patient_id"], :name => "index_histologies_on_patient_id"

  create_table "histologies_organs", :id => false, :force => true do |t|
    t.integer "histology_id"
    t.integer "organ_id"
  end

  add_index "histologies_organs", ["histology_id"], :name => "index_histologies_organs_on_histology_id"
  add_index "histologies_organs", ["organ_id"], :name => "index_histologies_organs_on_organ_id"

  create_table "organs", :force => true do |t|
    t.string   "name"
    t.integer  "parent_id"
    t.datetime "created_at", :null => false
    t.datetime "updated_at", :null => false
  end

  create_table "patients", :force => true do |t|
    t.integer  "number"
    t.string   "name"
    t.string   "name2"
    t.date     "birthdate"
    t.boolean  "sex"
    t.datetime "created_at", :null => false
    t.datetime "updated_at", :null => false
  end

  create_table "reports", :force => true do |t|
    t.integer  "histology_id"
    t.text     "diagnosis"
    t.text     "findings"
    t.integer  "user_id"
    t.integer  "revision"
    t.boolean  "locked"
    t.datetime "created_at",   :null => false
    t.datetime "updated_at",   :null => false
  end

  add_index "reports", ["histology_id"], :name => "index_reports_on_histology_id"
  add_index "reports", ["user_id"], :name => "index_reports_on_user_id"

  create_table "users", :force => true do |t|
    t.string   "name"
    t.boolean  "sign_out"
    t.datetime "created_at",      :null => false
    t.datetime "updated_at",      :null => false
    t.string   "password_digest"
  end

end
