<?php
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'User.class.php');
/**
 * System Administrator Object Class extends system_login_User
 * @package system
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 */
class system_login_Administrator extends system_login_User {
	/** Unique user id	*/
	var $userId			= SYSTEM_LOGIN_ADMINISTRATOR_USER_ID;
	/** Login ID	*/
	var $loginId		= SYSTEM_LOGIN_ADMINISTRATOR_LOGIN_ID;
	/** Login Password	*/
	var $loginPassword	= SYSTEM_LOGIN_ADMINISTRATOR_LOGIN_PASSWORD;
	/** Login view name	*/
	var $viewName		= SYSTEM_LOGIN_ADMINISTRATOR_NAME;
	/**
	 * Constructor
	 */
	public function __construct(){
	}
	/**
	 * (non-PHPdoc)
	 * @see system_login_User::loadByLoginId()
	 */
	function loadByLoginId( & $request, $loginId ) {
		if( $this->load($request) ) {
			if( $loginId == $this->loginId ) {
				return true;
			}
		}
		return false;
	}
	/**
	 * (non-PHPdoc)
	 * @see system_Data::getValidateRule()
	 */
	function getValidateRule(&$request){
		return array();
	}
	/**
	 * (non-PHPdoc)
	 * @see system_login_User::loadByEmail()
	 */
	function loadByEmail( & $request, $email ) {
		if( $this->load($request) ) {
			if( isset($GLOBALS['SPIDER_MAIL_SETTINGS'])
			&& isset($GLOBALS['SPIDER_MAIL_SETTINGS']['from_address']) ){
				if( $email == $GLOBALS['SPIDER_MAIL_SETTINGS']['from_address'] ) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		}
		return false;
	}
	/**
	 * (non-PHPdoc)
	 * @see system_login_User::getUniqueId()
	 */
	function getUniqueId() {
		return $this->userId;
	}
	/**
	 * (non-PHPdoc)
	 * @see system_login_User::getLoginId()
	 */
	function getLoginId(){
		return $this->loginId;
	}
	/**
	 * (non-PHPdoc)
	 * @see system_login_User::getEmail()
	 */
	function getEmail(){
		if( isset($GLOBALS['SPIDER_MAIL_SETTINGS'])
		&& isset($GLOBALS['SPIDER_MAIL_SETTINGS']['from_address'])
		&& strlen($GLOBALS['SPIDER_MAIL_SETTINGS']['from_address'])>0 ){
			return $GLOBALS['SPIDER_MAIL_SETTINGS']['from_address'];
		}
		return false;
	}
	/**
	 * (non-PHPdoc)
	 * @see system_login_User::getUserViewName()
	 */
	function getUserViewName() {
		return $this->viewName;
	}
	/**
	 * (non-PHPdoc)
	 * @see system_login_User::getLoginGroupLevel()
	 */
	function getLoginGroupLevel(){
		return SYSTEM_LOGIN_USER_ADMINISTRATORS;
	}
	/**
	 * (non-PHPdoc)
	 * @see system_login_User::confirmPassword()
	 */
	function confirmPassword( & $request, $inputPassword ) {
		if( strlen($inputPassword) == 0 ){
			return false;
		}
		if( $this->loginPassword == $this->encodePassword($request,$inputPassword) ) {
			return true;
		} else if( $inputPassword == $this->decodePassword( $request, $this->loginPassword ) ){
			return true;
		} else if( $this->loginPassword == $inputPassword ) {
			return true;
		}
		return false;
	}
	/**
	 * (non-PHPdoc)
	 * @see system_login_User::renewPassword()
	 */
	function renewPassword( & $request ) {
		$newPassword			= parent::renewPassword( $request );
		$this->loginPassword	= $this->encodePassword($request,$newPassword);
		return false;
	}
	/**
	 * (non-PHPdoc)
	 * @see system_login_User::hasUriPermittion()
	 */
	function hasUriPermittion( $uri ) {
		return true;
	}
	//
	// override methods
	//
	/**
	 * load saved data
	 * @param object $request spider_HttpRequest
	 * @param string $uniqueId
	 * @return boolean true/false
	 */
	function load( & $request ) {
		$systemDefineFile	= DIR_PATH_DATA.DIRECTORY_SEPARATOR.'system.define.inc.php';
		if( parent::load( $request, SYSTEM_LOGIN_ADMINISTRATOR_USER_ID ) ) {
			return true;
		} else if( file_exists($systemDefineFile) ) {
			require_once($systemDefineFile);
			$this->userId	= SYSTEM_LOGIN_ADMINISTRATOR_USER_ID;
			if( defined('SYSTEM_ADMIN_LOGIN_ID') ) {
				$this->loginId	= SYSTEM_ADMIN_LOGIN_ID;
			}
			if( defined('SYSTEM_ADMIN_LOGIN_PASSWORD') ) {
				$this->loginPassword	= SYSTEM_ADMIN_LOGIN_PASSWORD;
			}
			if( defined('SYSTEM_MAIL_FROM_NAME') ) {
				$this->viewName	= SYSTEM_MAIL_FROM_NAME;
			}
			return true;
		} else {
			$this->userId			= SYSTEM_LOGIN_ADMINISTRATOR_USER_ID;
			$this->loginId			= SYSTEM_LOGIN_ADMINISTRATOR_LOGIN_ID;
			$this->loginPassword	= SYSTEM_LOGIN_ADMINISTRATOR_LOGIN_PASSWORD;
			$this->viewName			= SYSTEM_LOGIN_ADMINISTRATOR_NAME;
			return true;
		}
	}
}
?>