<?php
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Model.class.php');
/**
 * ログイン用ビジネスモデルクラス
 * 
 * 管理システムにログインする機能を提供します。
 * ログイン情報読み込みの処理は設定ファイルに指定されたsystem_admin_IFLoginインターフェースの
 * 実装に移譲します。設定ファイルにログイン情報読み込み処理が指定されていない場合、
 * システム管理者ログイン情報を利用してログイン処理を行います。
 * 
 * @package system
 * @copyright Copyright (c) 2011, framework-fpider Developer Team.
 * @link http://sourceforge.jp/projects/frameworkspider/
 * @author  Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 */
class system_login_Login extends system_login_Model {
	function system_login_Login(){
	}
	/**
	 * require models
	 */
	function getRequireModels() {
		return array(
		'spider.model.Session',
		'spider.model.Language',
		'spider.model.AutoEncode',
		);
	}
	function execute( & $request ) {
		$keepLogin		= trim($request->getParam('keep'));
		$loginId		= $request->getParam('login_id');
		$loginPassword	= $request->getParam('password');
		// ログイン操作のたびにセッションIDを変更
		$request->renewSessionId();
		// ログインベースURIの確認
		if( !$request->existsSession(SYSTEM_SESSION_NAME_LOGIN_BASE_URI) ) {
			$request->setSession( SYSTEM_SESSION_NAME_LOGIN_BASE_URI, dirname(SPIDER_URI_REQUEST)
				, SPIDER_SESSION_SCOPE_GLOBAL );
		}
		// リダイレクトURLの確認
		$redirectUri	= $request->getSession( SYSTEM_SESSION_NAME_LAST_LOGIN_ERROR_URI );
		// ログインユーザーオブジェクトの宣言 
		$loginInformationObject	= null;
		$loginUserClassName		= null;
		if ( strlen( $loginId ) < 1 ) {
			$request->addError('system.error.login.user.requireloginid');
		}
		if ( strlen( $loginPassword ) < 1 ){
			$request->addError('system.error.login.user.requirepassword');
		}
		if( !$request->isError() ) {
			$loginInformationObject	= system_login_User::getUserObjectByLoginId( $request, $loginId );
			if( $loginInformationObject === false ) {
				// 全ての定義クラスで読み込んでもユーザーが見つからない場合はエラー
				$request->addError('system.error.login.user.invalidlogin');
			} else {
				$loginUserClassName	= get_class($loginInformationObject);
			}
		}
		if( !$request->isError() ) {
			if( $loginInformationObject->confirmPassword( $request, $loginPassword ) ){
			} else {
				$request->addError('system.error.login.user.invalidlogin');
			}
		}
		if ( $request->isError() || is_null($loginInformationObject) ) {
			// ログインエラーの場合はリダイレクト先をセッションに再登録
			$request->setSession( SYSTEM_SESSION_NAME_LAST_LOGIN_ERROR_URI, $redirectUri, SPIDER_SESSION_SCOPE_GLOBAL );
			if( !is_null($loginInformationObject) && is_a($loginInformationObject,'system_login_User') ) {
				$loginInformationObject->doLog($request,UALOG_TAG_ACCESS,UALOG_ACTION_LOGIN_FAILURE,'SELF','');
			}
		} else {
			// ログインに成功している場合
			$loginInformationObject->doLog($request,UALOG_TAG_ACCESS,UALOG_ACTION_LOGIN,'SELF','');
			// 情報をログイン情報をセッションに登録
			$request->setSession( SYSTEM_SESSION_NAME_LOGIN_INFORMATION, $loginInformationObject, SPIDER_SESSION_SCOPE_GLOBAL );
			$request->setSession( SYSTEM_SESSION_NAME_LOGIN_CLASS_NAME, $loginUserClassName, SPIDER_SESSION_SCOPE_GLOBAL );
			// クッキーを焼く(期間は30日間固定)
			if ( 'on' == $keepLogin ) {
				setcookie(SYSTEM_COOKIE_NAME_LOGIN_ID, $loginId, time()+(60*60*24*30));
				setcookie(SYSTEM_COOKIE_NAME_LOGIN_PASSWORD, $loginPassword, time()+(60*60*24*30));
			} else {
				setcookie(SYSTEM_COOKIE_NAME_LOGIN_ID, null, time()+(60*60*24*30));
				setcookie(SYSTEM_COOKIE_NAME_LOGIN_PASSWORD, null, time()+(60*60*24*30));
			}
			$request->removeSession( SYSTEM_SESSION_NAME_LAST_LOGIN_ERROR_URI, SPIDER_SESSION_SCOPE_GLOBAL );
			
			if ( strlen( trim( $redirectUri ) ) > 0 ) {
				// リダイレクト先が指定されているならリダイレクト
				$request->setResponseHeader( 'Expires', 'Mon, 26 Jul 1997 05:00:00 GMT' );
				$request->setResponseHeader( 'Cache-Control', 'no-store, no-cache, must-revalidate' );
				$request->setResponseHeader( 'Cache-Control', 'pre-check=0, post-check=0, max-age=0' );
				$request->setResponseHeader( 'Pragma', 'no-cache' );
				$request->setResponseHeader( 'Expires', '0' );
				$request->redirectTo($redirectUri);
			} else {
				// リダイレクト先が指定されていないならindex.phpにリダイレクト
				if( $request->existsSession(SYSTEM_SESSION_NAME_LOGIN_BASE_URI) ) {
					$redirectUri	= $request->getSession( SYSTEM_SESSION_NAME_LOGIN_BASE_URI );
				}
				$this->pageRedirect( $request, 'index.php' );
			}
		}
	}
}
?>