<?php
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Model.class.php');
/**
 * ログウト用ビジネスモデルクラス
 * 
 * 管理システムにログインする機能を提供します。
 * ログイン情報読み込みの処理は設定ファイルに指定されたsystem_admin_IFLoginインターフェースの
 * 実装に移譲します。設定ファイルにログイン情報読み込み処理が指定されていない場合、
 * システム管理者ログイン情報を利用してログイン処理を行います。
 * 
 * @package system
 * @copyright Copyright (c) 2011, framework-fpider Developer Team.
 * @link http://sourceforge.jp/projects/frameworkspider/
 * @author  Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 */
class system_login_Logout extends system_login_Model {
	function system_login_Logout(){
	}
	/**
	 * require models
	 */
	function getRequireModels() {
		return array(
		'spider.model.Session',
		'spider.model.Language',
		'spider.model.AutoEncode',
		);
	}
	function execute( & $request ) {
		$is_login	= $this->isLogin( $request );
		if( $is_login === true ) {
			// ログイン情報セッションを削除
			$request->removeSession( SYSTEM_SESSION_NAME_LOGIN_INFORMATION, SPIDER_SESSION_SCOPE_GLOBAL );
			$request->removeSession( SYSTEM_SESSION_NAME_LOGIN_CLASS_NAME, SPIDER_SESSION_SCOPE_GLOBAL );
			$isLogin	= false;
			$loginInfo	= null;
			$request->setAttribute('system.login.logininformation',$loginInfo);
			$request->setAttribute('system.login.is_login',$isLogin);
			// ログアウト操作のたびにセッションIDを変更
			$request->renewSessionId();
		}
	}
}
?>