<?php
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'spider'
.DIRECTORY_SEPARATOR.'Model.class.php');
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Administrator.class.php' );
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Guest.class.php' );
/**
 * spider : ログイン要求用ビジネスモデル基底クラス
 * 
 * 本ビジネスモデルをページ側でコールすると、該当するページ及びディレクトリ内で
 * ログイン必須となります。
 * 
 * @package system
 * @copyright Copyright (c) 2011, framework-fpider Developer Team.
 * @link http://sourceforge.jp/projects/frameworkspider/
 * @author  Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 */
class system_login_Model extends spider_Model {
	var $systemPackageConfig	= null;
	function system_login_Model(){
	}
	/**
	 * require models
	 */
	function getRequireModels() {
		return array(
		'spider.model.Session',
		'spider.model.Language',
		'spider.model.AutoEncode',
		);
	}
	function execute( & $request ) {
	}
	/**
	 * ログインしているか確認します
	 * ログインされていないまたはエラーが発生している場合はfalseを返します
	 * @param $request spider_HttpRequestオブジェクト
	 * @return mixed
	 */
	function isLogin( & $request ) {
		$userClassName	= $request->getSession(SYSTEM_SESSION_NAME_LOGIN_CLASS_NAME);
		if( !is_null($userClassName) ) {
			system_login_User::loadEnableLoginUserClasses();
			// ログインユーザー情報をセッションから取得
			if( !$request->existsSession(SYSTEM_SESSION_NAME_LOGIN_INFORMATION) ) {
				// ログインされていない
				return false;
			} else {
				$loginInformationObject	= $request->getSession(SYSTEM_SESSION_NAME_LOGIN_INFORMATION);
				if( is_a($loginInformationObject,'system_login_User')
					&& 'system_login_userguest' != strtolower(get_class($loginInformationObject)) ) {
					// ユーザークラスの実装として定義されていてゲストでない場合
					return true;
				} else {
					return false;
				}
			}
		} else {
			return false;
		}
	}
	/**
	 * ログインユーザー情報オブジェクトを取得します
	 * ログインされていない場合はsystem_login_Guestオブジェクトを返します
	 * システムエラーの場合はfalseを返します。
	 * @param $request spider_HttpRequestオブジェクト
	 * @return mixed
	 */
	function getLoginUserObject( & $request ) {
		if( system_login_Model::isLogin( $request ) ) {
			return $request->getSession(SYSTEM_SESSION_NAME_LOGIN_INFORMATION);
		} else {
			// ログインしていない場合固定でsystem_login_Guestオブジェクトを返す
			return new system_login_Guest();
		}
	}
	/**
	 * ログインユーザー情報オブジェクトを設定します
	 * システムエラーの場合はfalseを返します。
	 * @param $request spider_HttpRequestオブジェクト
	 * @return mixed
	 */
	function setLoginUserObject( & $request, $loginInformationObject ) {
		if( is_a($loginInformationObject,'system_login_User')
			&& !is_a($loginInformationObject,'system_login_Guest') ) {
			$request->setSession(SYSTEM_SESSION_NAME_LOGIN_INFORMATION, $loginInformationObject, SPIDER_SESSION_SCOPE_GLOBAL);
			$request->setSession( SYSTEM_SESSION_NAME_LOGIN_CLASS_NAME, get_class($loginInformationObject), SPIDER_SESSION_SCOPE_GLOBAL );
			return true;
		}
		return false;
	}
	/**
	 * 指定ページファイルにリダイレクトします
	 */
	function pageRedirect( & $request, $pageFile ) {
		Spider::loadClassDefinition('spider_File');
		$targetFolderUri	= dirname(SPIDER_URI_APP).'/';
		$redirectUri		= null;
		$targetFileUri		= null;
		while( strlen($targetFolderUri) > 0 ) {
			$targetFileUri	= $targetFolderUri.$pageFile;
			if( spider_File::isExists($targetFileUri,'public')
				&& $targetFileUri != SPIDER_URI_APP ) {
				break;
			} else if( DIRECTORY_SEPARATOR == $targetFolderUri ) {
				break;
			} else {
				$targetFileUri	= null;
				if( DIRECTORY_SEPARATOR == dirname($targetFolderUri) ) {
					$targetFolderUri	= '/';
				} else {
					$targetFolderUri	= dirname($targetFolderUri).'/';
				}
			}
		}
		if( is_null($targetFileUri) ) {
			// 指定名のファイルが見つからなかった場合
			if( $request->existsSession(SYSTEM_SESSION_NAME_LOGIN_BASE_URI) ) {
				// セッションにログインベースがあるなら
				$loginBaseUri	= $request->getSession(SYSTEM_SESSION_NAME_LOGIN_BASE_URI);
				if( preg_match('/\\/$/',$loginBaseUri) == 0 ) {
					$loginBaseUri	.= '/';
				}
				// ログインベースURIにターゲットファイルがあるか確認
				$targetFileUri	= $loginBaseUri.$pageFile;
				if( spider_File::isExists($targetFileUri,'public') ) {
					$redirectUri	= $targetFileUri;
				} else {
					$redirectUri	= $loginBaseUri;
					if( SPIDER_PHP_SELF == $loginBaseUri.'index.php' ) {
						// ログインベースがリダイレクトを発生させようとしているページと同一ならアプリケーションベース
						$redirectUri	= SPIDER_URI_BASE;
					}
				}
			} else {
				$redirectUri	= SPIDER_URI_BASE;
			}
		} else {
			// アプリケーション内URIから設置絶対URIに変換
			$targetFileUri	= str_replace('//','/',SPIDER_URI_BASE.$targetFileUri);
			$redirectUri	= $targetFileUri;
		}
		$redirectUri	= str_replace('//','/',$redirectUri);
		$request->setResponseHeader( 'Expires', 'Mon, 26 Jul 1997 05:00:00 GMT' );
		$request->setResponseHeader( 'Cache-Control', 'no-store, no-cache, must-revalidate' );
		$request->setResponseHeader( 'Cache-Control', 'pre-check=0, post-check=0, max-age=0' );
		$request->setResponseHeader( 'Pragma', 'no-cache' );
		$request->setResponseHeader( 'Expires', '0' );
		$request->redirectTo($redirectUri);
	}
	/**
	 * 渡されたData実装オブジェクトに対して編集ロックを取得します。
	 * @param &$request spider_HttpRequestオブジェクト参照
	 * @param $abstractData system_Data実装オブジェクト
	 * @param $lifeTime ロックの有効秒数
	 * @return ロックを取得出来たらtrue
	 */
	function lockData( & $request, $abstractData, $lifeTime=300 ) {
		$userObject	= $this->getLoginUserObject( $request );
		return $userObject->lockData( $request, $abstractData, $lifeTime );
	}
	/**
	 * 渡されたDataオブジェクトに対して編集ロックを解除します。
	 * @param &$request spider_HttpRequestオブジェクト参照
	 * @param $abstractData system_Data実装オブジェクト
	 * @return ロックを解除出来たらtrue
	 */
	function unlockData( & $request, $abstractData ) {
		$userObject	= $this->getLoginUserObject( $request );
		return $userObject->unlockData( $request, $abstractData );
	}
	/**
	 * 渡されたDataオブジェクトに対して編集ロックを取得可能か確認します。
	 * @param &$request spider_HttpRequestオブジェクト参照
	 * @param $abstractData system_Data実装オブジェクト
	 * @return ロックを取得できるならtrue/取得できないならfalse
	 */
	function canLockData( & $request, $abstractData ) {
		$userObject	= $this->getLoginUserObject( $request );
		return $userObject->canLockData( $request, $abstractData );
	}
	/**
	 * 渡されたDataオブジェクトに対して現在のロック状態をメンバとして設定します。
	 * ->is_lock = true/false
	 * ->is_editable = true/false
	 * @param &$request spider_HttpRequestオブジェクト参照
	 * @param $abstractData system_Data実装オブジェクト
	 */
	function setLockStatus( & $request, & $abstractData ) {
		$userObject	= $this->getLoginUserObject( $request );
		if( $abstractData->isLock() ) {
			$abstractData->is_lock		= true;
			if( $userObject->canLockData( $request, $abstractData ) ) {
				$abstractData->is_editable	= true;
			} else {
				$abstractData->is_editable	= false;
			}
		} else {
			$abstractData->is_lock		= false;
			$abstractData->is_editable	= true;
		}
	}
}
?>