<?php
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Model.class.php');
/**
 * spider : ログイン要求用ビジネスモデルクラス
 * 
 * 本ビジネスモデルをページ側でコールすると、該当するページ及びディレクトリ内で
 * ログイン必須となります。
 * 
 * @package system
 * @copyright Copyright (c) 2011, framework-fpider Developer Team.
 * @link http://sourceforge.jp/projects/frameworkspider/
 * @author  Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 */
class system_login_Require extends system_login_Model {
	function system_login_Require(){
	}
	/**
	 * require models
	 */
	function getRequireModels() {
		return array(
		'spider.model.Session',
		'spider.model.Language',
		'spider.model.AutoEncode',
		);
	}
	function execute( & $request ) {
		// ログインフラグ
		$loginInformationObject	= null;
		$is_login		= $this->isLogin( $request );
		if( $is_login === true ) {
			$loginInformationObject	= $this->getLoginUserObject( $request );
			$request->setAttribute('system.login.logininformation', $loginInformationObject );
		}
		$request->setAttribute('system.login.is_login', $is_login );
		// アクセス権限の確認
		if( $is_login && is_a($loginInformationObject,'system_login_User') ) {
			// ログインしているなら指定URIへのアクセス権限があるか確認する
			if( $loginInformationObject->hasUriPermittion(SPIDER_URI_APP) ) {
				// URIへのアクセス権限があるなら
			} else {
				$request->addError('system.error.login.user.noauth','',array(),false,SPIDER_LOG_LEVEL_ERROR);
				// アクセス権限がないならエラーページにリダイレクト
				$this->pageRedirect( $request, 'noauth.php' );
			}
		} else {
			// ログインしていないならセッションにリクエストされたURIを登録
			if( preg_match('/\\.js\\.php$/',SPIDER_URI_APP) == 0 ) {
				$request->setSession( SYSTEM_SESSION_NAME_LAST_LOGIN_ERROR_URI
					, SPIDER_URI_REQUEST
					, SPIDER_SESSION_SCOPE_GLOBAL );
			}
			$request->addError('system.error.login.user.requirelogin','',array(),false,SPIDER_LOG_LEVEL_ERROR);
			// nologin.phpファイルへリダイレクト
			$this->pageRedirect( $request, 'nologin.php' );
		}

		return;
	}
}
?>