<?php
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'Data.class.php');
define('UALOG_TAG_ACCESS','ACCESS');
define('UALOG_ACTION_LOGIN','LOGIN');
define('UALOG_ACTION_LOGIN_FAILURE','LOGIN FAILURE');
define('UALOG_ACTION_LOGOUT','LOGOUT');
/**
 * システムログインユーザーの為の抽象クラス
 * @package system
 * @copyright Copyright (c) 2011, framework-fpider Developer Team.
 * @link http://sourceforge.jp/projects/frameworkspider/
 * @author  Masanori Nakashima <m_nakashima@users.sourceforge.jp>
 */
abstract class system_login_User extends system_Data {
	/**
	 * ログインIDからユーザーを読み込む抽象メソッド
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $loginId ログインID
	 * @return boolean 一意のユーザを読み込むことができればtrue
	 */
	public abstract function loadByLoginId( & $request, $loginId );
	/**
	 * メールアドレスからユーザーを読み込む抽象メソッド
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $loginId ログインID
	 * @return boolean 一意のユーザを読み込むことができればtrue
	 */
	public abstract function loadByEmail( & $request, $email );
	/**
	 * get login id
	 * @return string $loginId システム全体で一意のログイン識別記号
	 */
	public abstract function getLoginId();
	/**
	 * get email
	 * @return strings email
	 */
	public abstract function getEmail();
	/**
	 * get user view name
	 * @return string $viewName ログイン者の表示名
	 */
	public abstract function getUserViewName();
	/**
	 * ログインパスワードを照合します
	 * @param spider_HttpRequest &$request spider_HttpRequestクラスオブジェクトの参照
	 * @param string $inputPassword 入力されたパスワード
	 * @return boolean パスワードが一致したらtrue
	 */
	public abstract function confirmPassword( & $request, $inputPassword );
	/**
	 * システムグループレベルを取得します
	 * SYSTEM_LOGIN_USER_ADMINISTRATORS 0 管理者グループ
	 * SYSTEM_LOGIN_USER_POWERS パワーユーザーグループ
	 * SYSTEM_LOGIN_USER_USERS 一般ユーザーグループ
	 * SYSTEM_LOGIN_USER_GUEST ゲストユーザー グループ
	 */
	abstract public function getLoginGroupLevel();
	/**
	 * Activity Log
	 * @param spider_HttpRequest $request
	 * @param string $tag
	 * @param string $action
	 * @param string $target
	 * @param string $detail
	 */
	public function doLog( & $request, $tag, $action, $target, $detail ){
		
	}
	/**
	 * ログインパスワードをランダムに再発行します
	 * @param spider_HttpRequest &$request spider_HttpRequestクラスオブジェクトの参照
	 * @return mixed 新しく発行したパスワード文字列。再発行に失敗したらfalse。
	 */
	function renewPassword( & $request ) {
		Spider::loadClassDefinition('util_CharUtility');
		return util_CharUtility::getRundomKey( 8 );
	}
	/**
	 * 実装メソッド：パスワードをシステム設定された方法で暗号化
	 * 暫定でここに追加。バージョン２ではライブラリ場所を検討すること
	 */
	function encodePassword( & $request, $password, $key='', $type='' ) {
		Spider::loadClassDefinition('util_Encrypt');
		$encryptObject	= new util_Encrypt($key, $type);
//		$pass	= $encryptObject->encode($password, $key);
		$pass	= $encryptObject->sha1($password);
		return $pass;
	}
	function decodePassword( & $request, $password, $key='', $type='' ) {
		Spider::loadClassDefinition('util_Encrypt');
		$encryptObject	= new util_Encrypt($key, $type);
		$pass	= $encryptObject->decode($password,$key);
		return $pass;
	}
	//
	// アクセス権限に関するメソッド
	//
	/**
	 * 指定のURIを表示する権限があるか確認します
	 */
	abstract public function hasUriPermittion( $uri );
	//
	// データ扱いの権限に関するメソッド
	//
	/**
	 * 本オブジェクトのデータを渡されたUserが閲覧できるか確認します
	 * @param &$request spider_HttpRequestオブジェクト
	 * @param $abstractUser system_login_User実装クラスインスタンス
	 */
	function canViewData( & $request, $abstractUser ) {
		return true;
	}
	/**
	 * 渡されたDataオブジェクトに対する編集権限があるか確認します
	 * @param &$request spider_HttpRequestオブジェクト
	 * @param $abstractUser system_login_User実装クラスインスタンス
	 */
	function canEditData( & $request, $abstractUser ) {
		return true;
	}
	//
	// データの編集ロックに関するメソッド
	//
	/**
	 * 渡されたDataオブジェクトに対して編集ロックを取得します。
	 * @param &$request spider_HttpRequestオブジェクト参照
	 * @param $abstractData system_Data実装オブジェクト
	 * @param $lifeTime ロックの有効秒数
	 * @return ロックを取得出来たらtrue
	 */
	function lockData( & $request, $abstractData, $lifeTime=300 ) {
		if( $abstractData->canEditData( $request, $this ) ) {
			// 編集可能なデータならロック識別子を生成する
			$operatorId	= $this->lockCreateOperatorId();
			return $abstractData->lock( $operatorId, $lifeTime );
		}
		return false;
	}
	/**
	 * 渡されたDataオブジェクトに対して編集ロックを解除します。
	 * @param &$request spider_HttpRequestオブジェクト参照
	 * @param $abstractData system_Data実装オブジェクト
	 * @return ロックを解除出来たらtrue
	 */
	function unlockData( & $request, $abstractData ) {
		if( $abstractData->canEditData( $request, $this ) ) {
			$operatorId	= $this->lockCreateOperatorId();
			return $abstractData->unlock( $operatorId );
		}
		return false;
	}
	/**
	 * 渡されたDataオブジェクトに対して編集ロックを取得可能か確認します。
	 * @param &$request spider_HttpRequestオブジェクト参照
	 * @param $abstractData system_Data実装オブジェクト
	 * @return ロックを取得できるならtrue/取得できないならfalse
	 */
	function canLockData( & $request, $abstractData ) {
		if( $abstractData->canEditData( $request, $this ) ) {
			$operatorId	= $this->lockCreateOperatorId();
			return $abstractData->canLock( $operatorId );
		}
		return false;
	}
	/**
	 * 本オブジェクトユーザーでロックに使用するロック固有識別子を取得します。
	 * @return ロック固有識別子の文字列
	 */
	function lockCreateOperatorId() {
		return get_class($this)."\r\n"
			.$this->getUniqueId();
	}
	//
	// system_Dataの実装とオーバーライド
	//
	/**
	 * データ保存区分名を取得する抽象メソッドの実装
	 * 固定で'user'とする
	 */
	function getDataClassName(){
		return 'user';
	}
	/**
	 * データ固有のIDを取得する抽象メソッドの実装
	 * ログインIDを返します
	 */
	function getUniqueId(){
		return $this->getLoginId();
	}
	/**
	 * データ保存区分と設定メンバ値に従って本オブジェクトのデータを保存するメソッドのオーバーロード
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @return boolean 保存に成功したらtrue, 失敗したらfalse
	 */
	function save( & $request ) {
		return parent::save( $request, 2, false );
	}
	/**
	 * データ保存区分と固有IDから保存データを本オブジェクトのメンバ値に読み込むメソッドのオーバーロード
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $uniqueId 固有ID
	 * @return boolean 読み込みに成功したらtrue, 失敗したらfalse
	 */
	function load( & $request, $uniqueId ) {
		return parent::load( $request, $uniqueId, 2 );
	}
	/**
	 * データ保存区分と固有IDから保存データを削除するメソッドのオーバーロード
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $uniqueId 固有ID
	 * @param integer $explodeIdLength 0以下の場合分割しない
	 * @param boolean $saveSlaveServers trueならスレーブサーバのdataフォルダがマウントされている場合にスレーブサーバも削除する
	 * @return boolean 削除に成功したらtrue, 失敗したらfalse
	 */
	function delete( & $request, $uniqueId ) {
		return parent::delete( $request, $uniqueId, 2, false );
	}
	// for mail
	/**
	 * send renewal password
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $targetAddress 送信ターゲットメールアドレス指定
	 */
	function sendRenewalPassword( $request, $replaceHash=array() ) {
		if( $newPassword = $this->renewPassword( $request ) ) {
			if(!is_array($replaceHash)){
				$replaceHash = array();
			}
			$replaceHash['login_password'] = $newPassword;
			return $this->sendTemplateMail($request,'notify.password',$replaceHash,null );
		} else {
			return false;
		}
	}
	/**
	 * send mail
	 * @param spider_HttpRequest $request
	 * @param strings $subject
	 * @param strings $textBody
	 * @param strings $htmlBody
	 * @param hash $replaceHash
	 * @param strings $from
	 * @param strings $reply
	 * @param strings $returnPath
	 * @param strings $bcc
	 */
	function sendMail( &$request, $subject, $textBody, $htmlBody=null, $replaceHash=array(),
	$from=null, $reply=null, $returnPath=null, $bcc=array() ){
		// 宛先確認
		$targetAddress	= $this->getEmail();
		if( strlen(trim($targetAddress)) == 0 ) {
			$request->addError('system.error.login.user.nomail','',array(),false,SPIDER_LOG_LEVEL_ERROR);
			return false;
		} else if( trim($this->email) != trim($targetAddress) ) {
			$request->addError('system.error.login.user.invalidmail','',array(),false,SPIDER_LOG_LEVEL_ERROR);
			return false;
		}
		// メールオブジェクト
		$mailerObject	= $request->getSystemMailer();
		if( false === $mailerObject ) {
			$request->addError('system.error.login.user.nomailsetting','',array(),false,SPIDER_LOG_LEVEL_ERROR);
			return false;
		}
		// 件名と本文の取得
		$mailerObject->subject		= $subject;
		$mailerObject->text_body	= $textBody;
		$mailerObject->html_body	= $htmlBody;
		// from
		if( isset($from) && strlen($from)>0 ) {
		} else if( defined('SYSTEM_MAIL_FROM_ADDRESS') ){
			$from	= SYSTEM_MAIL_FROM_ADDRESS;
			if( defined('SYSTEM_MAIL_FROM_NAME') ){
				$from	= SYSTEM_MAIL_FROM_NAME.' <'.$from.'>';
			}
		} else {
			$request->addError('system.error.login.user.nomailsetting','',array(),false,SPIDER_LOG_LEVEL_ERROR);
			return false;
		}
		// reply
		if( isset($reply) && strlen($reply) > 0 ) {
		} else if( defined('SYSTEM_MAIL_REPLY_ADDRESS') ){
			$reply	= SYSTEM_MAIL_REPLY_ADDRESS;
		} else {
			$reply	= $from;
		}
		// return
		if( isset($returnPath) && strlen($returnPath) > 0 ) {
		} else if( defined('SYSTEM_MAIL_REPLY_ADDRESS') ){
			$returnPath	= SYSTEM_MAIL_RETURN_ADDRESS;
		} else {
			$returnPath	= $from;
		}
		// replace words
		$mailerObject->addReplaceWordByObject('user',$this);
		if( is_array($replaceHash) ) {
			foreach( $replaceHash as $repWord => $repValue ) {
				if( is_object($repValue) ) {
					$mailerObject->addReplaceWordByObject( $repWord, $repValue );
				} else if( is_array($repValue) ) {
					$mailerObject->addReplaceWordByHash( $repWord, $repValue );
				} else {
					$mailerObject->addReplaceWord( $repWord, $repValue );
				}
			}
		}
		// send
		$bccString = implode(',',$bcc);
		$result	= $mailerObject->send( $targetAddress, $subject, $textBody, $htmlBody, $from, $reply, $returnPath, null, $bccString );
		if( $result ) {
			return true;
		} else {
			$request->addError('system.error.login.user.failtomail','',array(),false,SPIDER_LOG_LEVEL_ERROR);
			return false;
		}
	}
	/**
	 * send template mail
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $templateName メールテンプレート名
	 * @param $replaceHash 置き換えワード
	 * @param $bccArray ブラインドカーボンコピーアドレス
	 * @return 成功したらtrue、失敗したらfalse
	 */
	public function sendTemplateMail( &$request, $templateName, $replaceHash=array(), $bccArray=array() ){
		Spider::loadClassDefinition('system_login_MailTemplate');
		$mailTemplateObject = new system_login_MailTemplate($request,$templateName);
		return $mailTemplateObject->send($request,$this->getEmail(), $this->getUserViewName(), $replaceHash, $bccArray );
	}
	//
	// static methods
	//
	/**
	 * 指定されたログインIDがシステム上に存在するか確認します
	 * @param spider_HttpRequest &$request spider_HttpRequestクラスオブジェクトの参照
	 * @param string $loginId ログインID
	 * @return boolean 存在するならtrue / 存在しないかエラーが発生した場合にはfalse
	 * @access public
	 * @static
	 */
	public static function isExistLoginId( & $request, $loginId ){
		if( system_login_User::getUserObjectByLoginId( $request, $loginId ) ) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * get user object
	 * @param spider_HttpRequest $request
	 * @param strings $loginId
	 */
	public static function getUserObjectByLoginId( &$request, $loginId ){
		$classNameArray = system_login_User::loadEnableLoginUserClasses();
		foreach( $classNameArray as $className ){
			$loginInformationObject = Spider::createObject($className);
			if( is_a($loginInformationObject,'system_login_User') ) {
				// ユーザークラスの実装として定義されている
				if( $loginInformationObject->loadByLoginId( $request, $loginId ) ) {
					// 読み込みに成功したら存在する
					return $loginInformationObject;
				} else {
					// 読み込めなかったら次の定義クラスを確認する為エラーにしない
				}
			} else {
				// Userの実装ではないクラスが設定されている場合
				$request->addError('system.error.config.invalidsendclassname'
				,'',array($userClassName),false,SPIDER_LOG_LEVEL_FATAL);
				return false;
			}
		}
		return false;
	}
	/**
	 * get user object
	 * @param spider_HttpRequest $request
	 * @param strings $loginId
	 */
	public static function getUserObjectByEmail( &$request, $email ){
		$classNameArray = system_login_User::loadEnableLoginUserClasses();
		foreach( $classNameArray as $className ){
			$loginInformationObject = Spider::createObject($className);
			if( is_a($loginInformationObject,'system_login_User') ) {
				// ユーザークラスの実装として定義されている
				if( $loginInformationObject->loadByEmail( $request, $email ) ) {
					// 読み込みに成功したら存在する
					return $loginInformationObject;
				} else {
					// 読み込めなかったら次の定義クラスを確認する為エラーにしない
				}
			} else {
				// Userの実装ではないクラスが設定されている場合
				$request->addError('system.error.config.invalidsendclassname'
				,'',array($userClassName),false,SPIDER_LOG_LEVEL_FATAL);
				return false;
			}
		}
		return false;
	}
	/**
	 * load enable login user classes
	 */
	public static function loadEnableLoginUserClasses(){
		$names = scandir(DIR_PATH_LIB);
		foreach( $names as $name ){
			if(strpos($name,'.')===0 || !is_dir(DIR_PATH_LIB.'/'.$name)){
			} else {
				if( file_exists(DIR_PATH_SPIDER.'/development') ){
					$settingPath = DIR_NAME_DATA.'/dev/'.$name.'.define.inc.php';
					if( file_exists($settingPath) ){
						require_once($settingPath);
					} else {
						$settingPath = DIR_NAME_DATA.'/'.$name.'.define.inc.php';
						if( file_exists($settingPath) ){
							require_once($settingPath);
						}
					}
				} else {
					$settingPath = DIR_NAME_DATA.'/'.$name.'.define.inc.php';
					if( file_exists($settingPath) ){
						require_once($settingPath);
					}
				}
			}
		}
		if( !isset($GLOBALS['SYSTEM_LOGIN_CLASSES']) || !is_array($GLOBALS['SYSTEM_LOGIN_CLASSES']) ){
			$GLOBALS['SYSTEM_LOGIN_CLASSES']	= array();
		}
		array_unshift($GLOBALS['SYSTEM_LOGIN_CLASSES'],'system_login_Administrator');
		return $GLOBALS['SYSTEM_LOGIN_CLASSES'];
	}
}
?>