
#include "pnuts.hpp"

namespace GikoMona {
namespace pnuts {

bool application::OnInit() {
    wxXmlResource::Get()->InitAllHandlers();
    // init embedded resources.
    InitXmlResources();
    // init changeable resources.
    wxXmlResource::Get()->LoadAllFiles("resource");
    
    config = new config;
#ifdef ENABLE_TWITTER
    auto res = config.post_query<bool>("?:twitter/service=enable");
    if(res) {
        auto id_password
            = config.post_query<mona_string, mona_string>(
                ">:twitter/user/{id & password}"
            );
        twitter::login(id_password<0>, id_password<1>);
    }
#endif
    
    controller = new controller;
    model = new model;
    main_window = new main_window;
    model.main_window = main_window;
    main_window->PushEventHandler(controller);
    
    auto is_first_executation
        = config.post_query<bool>(
            "?:app/last-executation-time=inavailable"
        );
    
    if(is_first_executation) {
        show_welcome();
        main_window->Show();
        return true;
    } else {
        thread_window = new threaad_window;
        model.thread_window = thread_window;
        thread_window->PushEventHandler(controller);
        
        thread_window->Show();
        return true;
    }
}

int application::OnExit() {
    config.post_query<void>(
        "<:app/last-executation-time", "$:NOW"
    );
    return 0;
}

}
}
