/*
 * Decompiled with CFR 0.152.
 */
package jp.co.olympus.camerakit;

import android.graphics.PointF;
import android.graphics.RectF;
import jp.co.olympus.camerakit.OLYCamera;

public class OLYCameraUtilsTrait {
    protected OLYCameraUtilsTrait(OLYCamera.l adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
        if (!(adapter instanceof OLYCamera.l)) {
            throw new IllegalAccessError();
        }
    }

    public static PointF convertPointOnLiveImageIntoViewfinder(PointF point, float width, float height, int rotatedDegrees) {
        if (point == null) {
            throw new NullPointerException();
        }
        if (width == 0.0f || height == 0.0f) {
            throw new IllegalArgumentException();
        }
        PointF finderPoint = new PointF(point.x, point.y);
        finderPoint.x /= width;
        finderPoint.y /= height;
        switch (rotatedDegrees) {
            case 0: {
                break;
            }
            case 90: {
                finderPoint = new PointF(finderPoint.y, 1.0f - finderPoint.x);
                float swap = width;
                width = height;
                height = swap;
                break;
            }
            case 180: {
                finderPoint = new PointF(1.0f - finderPoint.x, 1.0f - finderPoint.y);
                break;
            }
            case 270: {
                finderPoint = new PointF(1.0f - finderPoint.y, finderPoint.x);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return finderPoint;
    }

    public static PointF convertPointOnViewfinderIntoLiveImage(PointF point, float width, float height, int rotatedDegrees) {
        if (point == null) {
            throw new NullPointerException();
        }
        if (width == 0.0f || height == 0.0f) {
            throw new IllegalArgumentException();
        }
        PointF viewPoint = new PointF(point.x, point.y);
        switch (rotatedDegrees) {
            case 0: {
                break;
            }
            case 90: {
                viewPoint = new PointF(1.0f - viewPoint.y, viewPoint.x);
                break;
            }
            case 180: {
                viewPoint = new PointF(1.0f - viewPoint.x, 1.0f - viewPoint.y);
                break;
            }
            case 270: {
                viewPoint = new PointF(viewPoint.y, 1.0f - viewPoint.x);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        viewPoint.x *= width;
        viewPoint.y *= height;
        return viewPoint;
    }

    public static RectF convertRectOnLiveImageIntoViewfinder(RectF rect, float width, float height, int rotatedDegrees) {
        if (rect == null) {
            throw new NullPointerException();
        }
        if (width == 0.0f || height == 0.0f) {
            throw new IllegalArgumentException();
        }
        PointF pointTL = OLYCameraUtilsTrait.convertPointOnLiveImageIntoViewfinder(new PointF(rect.left, rect.top), width, height, rotatedDegrees);
        PointF pointRB = OLYCameraUtilsTrait.convertPointOnLiveImageIntoViewfinder(new PointF(rect.right, rect.bottom), width, height, rotatedDegrees);
        float top = Math.min(pointTL.y, pointRB.y);
        float left = Math.min(pointTL.x, pointRB.x);
        float right = Math.max(pointTL.x, pointRB.x);
        float bottom = Math.max(pointTL.y, pointRB.y);
        return new RectF(left, top, right, bottom);
    }

    public static RectF convertRectOnViewfinderIntoLiveImage(RectF rect, float width, float height, int rotatedDegrees) {
        if (rect == null) {
            throw new NullPointerException();
        }
        if (width == 0.0f || height == 0.0f) {
            throw new IllegalArgumentException();
        }
        PointF pointTL = OLYCameraUtilsTrait.convertPointOnViewfinderIntoLiveImage(new PointF(rect.left, rect.top), width, height, rotatedDegrees);
        PointF pointRB = OLYCameraUtilsTrait.convertPointOnViewfinderIntoLiveImage(new PointF(rect.right, rect.bottom), width, height, rotatedDegrees);
        float top = Math.min(pointTL.y, pointRB.y);
        float left = Math.min(pointTL.x, pointRB.x);
        float right = Math.max(pointTL.x, pointRB.x);
        float bottom = Math.max(pointTL.y, pointRB.y);
        return new RectF(left, top, right, bottom);
    }
}

