#
# Copyright 2013-2014, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

$LOAD_PATH.push("#{File.dirname(__FILE__)}/_lib")
#${chef-repo}/roles/_lib/grid.rb
require 'grid'

cluster_name = 'praesepe'
cluster_sym = cluster_name.to_sym

name "hadoop-#{cluster_name}"
description "#{cluster_name.capitalize} Hadoop cluster node"

run_list(
  'role[node_commons]',
  # LDAP (option)
  #'role[nameservice-client-grid]',
  'role[hadoop]'
)

#env_run_lists()

grid_vol_root = '/grid/vol'
hadoop_attributes = {
  # core-site.xml
  'this.cluster.name' => cluster_name, 
  'this.domain' => Grid::DOMAIN,
  'this.namenode.fqdn' => '${this.cluster.name}-nn.${this.domain}',
  'fs.checkpoint.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/checkpoint",
  #'fs.checkpoint.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/checkpoint,/export/home/${user.name}/var/lib/checkpoint",
  # hdfs-site.xml
  'this.secondary.namenode.fqdn' => '${this.cluster.name}-cn.${this.domain}',
  'dfs.name.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/name",
  #'dfs.name.dir' => "#{grid_vol_root}/0/var/lib/${user.name}/name,/export/home/${user.name}/var/lib/name",
  'dfs.replication' => '2',
  #'dfs.replication' => '3',
  # mapred-site.xml
  'this.jobtracker.fqdn' => '${this.cluster.name}-jt.${this.domain}',
  'this.jobhistory.fqdn' => '${this.cluster.name}-jt.${this.domain}',
  #'this.jobhistory.fqdn' => '${this.cluster.name}-jh.${this.domain}',
  'extra_configs' => {
    # e.g. 'core-site.xml' => {'k1' => 'v1', 'k2' => 'v2'},
    'hadoop-env.sh' => {},
    'yarn-env.sh' => {},  # ver. 2.0
    'mapred-env.sh' => {},  # ver. 2.0
    'core-site.xml' => {},
    'hdfs-site.xml' => {
      # with HBase
      #'dfs.support.append' => 'true',
      #'truenode.max.xcievers' => '4096'
    },
    'yarn-site.xml' => {},  # ver. 2.0
    'mapred-site.xml' => {
      #'mapred.tasktracker.map.tasks.maximum' => '4',     # default: 2
      #'mapred.tasktracker.reduce.tasks.maximum' => '2',  # default: 2
      #'mapred.child.java.opts' => '-Xmx1000m',           # default: -Xmx200m
      #'mapred.reduce.slowstart.completed.maps' => '0.80',  # default: 0.05
      #'tasktracker.http.threads' => '80',                  # default: 40
      #'mapred.reduce.parallel.copies' => SQRT(nodes)       # default: 5
    },
    'capacity-scheduler.xml' => {}
  }
}

#default_attributes()

override_attributes(
  'grid' => {
    'vol_root' => grid_vol_root,
    'max_vol_nums' => '4'
  },
  'hadoop' => hadoop_attributes
)

