#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'screwdriver-on-docker'
description 'Screwdriver on Docker'

#ui_port     = '9000'
#api_port    = '9001'
#store_port  = '9002'

run_list(
  'role[docker]',
  'recipe[screwdriver::docker-compose]',
)

override_attributes(
  'screwdriver' => {
    'docker-compose' => {
      # REQUIRED: SCM OAuth client ID and secret
=begin
      'oauth_client_id_vault_item' => {
        'vault' => 'screwdriver',
        'name' => 'oauth_client_id',
        'env_context' => false,
        'key' => 'cid',  # real hash path: "/cid"
      },
      'oauth_client_secret_vault_item' => {
        'vault' => 'screwdriver',
        'name' => 'oauth_client_secret',
        'env_context' => false,
        'key' => 'secret',  # real hash path: "/secret"
      },
=end
      'config' => {
        'services' => {
          'api' => {
            'ports' => [
              #"#{api_port}:80",
            ],
            'environment' => {
              # REQUIRED: SCM settings
              'SCM_PLUGIN' => 'github',  # 'gitlab' or 'github' or 'bitbucket'
              # OAuth Callback URL: "http://#{node['fqdn']}:9001/v4/auth/login/web"
              'SCM_USERNAME' => 'ci-tool',
              'SCM_EMAIL' => 'citool@mail.example.com',
              #'WEBHOOK_GITHUB_SECRET' => 'SUPER-SECRET-SIGNING-THING',
              #'SCM_GITLAB_HOST' => 'gitlab.io.example.com',
              #'SCM_GITLAB_PROTOCOL' => 'https',
              #'NODE_TLS_REJECT_UNAUTHORIZED' => '0',  # for self-signed cetificates
              # The following variables will be set by the screwdriver::docker-compose recipe automatically.
              #'SECRET_OAUTH_CLIENT_ID' => '${SECRET_OAUTH_CLIENT_ID}',
              #'SECRET_OAUTH_CLIENT_SECRET' => '${SECRET_OAUTH_CLIENT_SECRET}',
              #'SECRET_JWT_PRIVATE_KEY' => '${SECRET_JWT_PRIVATE_KEY}',
              #'SECRET_JWT_PUBLIC_KEY' => '${SECRET_JWT_PUBLIC_KEY}',
              #'ECOSYSTEM_UI' => "http://#{node['fqdn']}:#{ui_port}",
              #'ECOSYSTEM_STORE' => "http://#{node['fqdn']}:#{store_port}",
            },
          },
          'ui' => {
            'ports' => [
              #"#{ui_port}:80",
            ],
            'environment' => {
              # These variables will be set by the screwdriver::docker-compose recipe automatically.
              #'ECOSYSTEM_API' => "http://#{node['fqdn']}:#{api_port}",
              #'ECOSYSTEM_STORE' => "http://#{node['fqdn']}:#{store_port}",
            },
          },
          'store' => {
            'ports' => [
              #"#{store_port}:80",
            ],
            'environment' => {
              # These variables will be set by the screwdriver::docker-compose recipe automatically.
              #'ECOSYSTEM_UI' => "http://#{node['fqdn']}:#{ui_port}",
              #'SECRET_JWT_PUBLIC_KEY' => '${SECRET_JWT_PUBLIC_KEY}',
            },
          },
        },
      },
    },
  },
)
