name 'devops-suite-on-docker'
description 'DevOps Suite on Docker'

aptly_port       = '7080'  # default: 8080
aptly_api_port   = '7081'  # default: 8081
concourse_port   = '8080'
gitlab_http_port =   '80'  # default: 80, and 8080 already in use.
gitlab_ssh_port  = '2022'
nexus_ver = '3'
nexus_port = nexus_ver == '3' ? '8081' : '8071'

run_list(
  'role[docker]',
  'role[aptly-on-docker]',
  'role[concourse-on-docker]',
  'role[gitlab-on-docker]',
  'role[gitlab-runner]',
  "role[nexus#{nexus_ver}-on-docker]",
)

#env_run_lists()

#default_attributes()

override_attributes(
  'docker-grid' => {
    'engine' => {
      'skip_setup' => false,
      'daemon_extra_options' => [
        '-H fd://',
        '--bip=192.168.100.1/24 --fixed-cidr=192.168.100.0/24',
      ].join(' '), 
    },
    'compose' => {
      'skip_setup' => false,
    },
  },
  'apt_utils' => {
    'aptly' => {
      'docker-compose' => {
        'config' => {
          'services' => {
            'reverseproxy' => {
              'ports' => [
                "#{aptly_port}:8080",
                "#{aptly_api_port}:8081",
              ],
              # 'network_mode' => 'bridge',
              # 'links' => [
              #   'aptly',
              # ],
            },
            'aptly' => {
              # 'network_mode' => 'bridge',
            },
          },
        },
      },
    },
  },
  'concourse-ci' => {
    'docker-compose' => {
      'config' => {
        # Version 1 docker-compose format
        'concourse-db' => {
        },
        'concourse-web' => {
          'ports' => [
            "#{concourse_port}:8080",
          ],
          'environment' => {
            # If you sepecify no value, Chef will sets "http://#{node['ipaddress']}:8080".
            #'CONCOURSE_EXTERNAL_URL' => "http://#{node['ipaddress']}:#{concourse_port}",
          },
        },
        'concourse-worker' => {
          'environment' => {
          },
        },
      },
    },
  },
  'gitlab-grid' => {
    'gitlab.rb' => {
      #'external_url' => "http://#{gitlab_cn}:#{gitlab_http_port}",
      'gitlab_rails' => {
        #'time_zone' => 'Asia/Tokyo',
        'gitlab_shell_ssh_port' => gitlab_ssh_port.to_i,
      },
    },
    'docker-compose' => {
      'config' => {
        'services' => {
          'gitlab' => {
            #'hostname' => gitlab_cn,
            'ports' => [
              "#{gitlab_http_port}:#{gitlab_http_port}",
              "#{gitlab_ssh_port}:22",
            ],
            'network_mode' => 'bridge',  # for the Container Registry feature.
          },
        },
      },
    },
    'runner-docker-compose' => {
      'import_ca' => false,
    },
  },
  'nexus-grid' => {
    'docker-compose' => {
      'config' => {
        'services' => {
          'reverseproxy' => {
            'ports' => [
              "#{nexus_port}:8081",
            ],
            # 'network_mode' => 'bridge',
            # 'links' => [
            #   'nexus',
            # ],
          },
          'nexus' => {
            #'image' => 'sonatype/nexus3',  # => role[nexus2/3-on-docker]
            # 'network_mode' => 'bridge',
          },
        },
      },
    },
  },
)
