bubbleupnp-server Cookbook
==========================

This cookbook sets up a BubbleUPnP Server by Docker-compose.
You can build BubbleUPnP Server Docker image too.

## Contents

- [Requirements](#requirements)
    - [platforms](#platforms)
    - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
    - [Recipes](#recipes)
        - [bubbleupnp-server::default](#bubbleupnp-serverdefault)
        - [bubbleupnp-server::docker-compose](#bubbleupnp-serverdocker-compose)
    - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### platforms

- Debian >= 10.x
- Ubuntu >= 18.04
- CentOS,RHEL >= 7.9

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['bubbleupnp-server']['Dockerfile']['FROM']`|String|Base image in the `Dockerfile`.|See `attributes/default.rb`|
|`['bubbleupnp-server']['docker-compose']['autopilot']`|Hash|Autopilot configurations.|See `attributes/default.rb`|
|`['bubbleupnp-server']['docker-compose']['app_dir']`|String||`"#{node['docker-grid']['compose']['app_dir']}/bubbleupnp-server"`|
|`['bubbleupnp-server']['docker-compose']['data_dir']`|String||`"#{node['bubbleupnp-server']['docker-compose']['app_dir']}/data"`|
|`['bubbleupnp-server']['docker-compose']['dot_env']`|Hash|`.env` configurations.|See `attributes/default.rb`|
|`['bubbleupnp-server']['docker-compose']['config']`|Hash|`docker-compose.yml` configurations.|See `attributes/default.rb`|

## Usage

### Recipes

#### bubbleupnp-server::default

This recipe does nothing.

#### bubbleupnp-server::docker-compose

This recipe generates a `docker-compose.yml` for the BubbleUPnP Server.

### Role Examples

- `roles/bubbleupnp-server-on-docker.rb`

```ruby
name 'bubbleupnp-server-on-docker'
description 'BubbleUPnP Server on Docker'

run_list(
  # see https://osdn.net/projects/metasearch/scm/git/grid-chef-repo/blobs/master/roles/docker-new-repo.rb
  'role[docker]',
  'recipe[bubbleupnp-server::docker-compose]',
)

#env_run_lists

#default_attributes

override_attributes(
  'bubbleupnp-server' => {
    'docker-compose' => {
      'dot_env' => {
        # use the official image
        # https://hub.docker.com/r/bubblesoftapps/bubbleupnpserver
        'REGISTRY' => 'bubblesoftapps',
        'NAME' => 'bubbleupnpserver',
        'VER' => 'latest',
        # Local build
        #'REGISTRY' => 'yourname',
        #'NAME' => 'bubbleupnpserver',
        #'VER' => '0.9-6',
      },
      'config' => {
        'services' => {
          'bubbleupnp-server' => {
            'restart' => 'unless-stopped',
          },
        },
      },
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2019-2022, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
