#
# Cookbook Name:: go_utils
# Recipe:: go-installer
#
# Copyright 2019, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

doc_url = 'https://golang.org/doc/'

[
  'curl',
].each {|pkg|
  resources(package: pkg) rescue package pkg do
    action :install
  end
}

[
  'go_install',
].each {|script|
  template "/usr/local/bin/#{script}" do
    source  "usr/local/bin/#{script}"
    owner 'root'
    group 'root'
    mode '0755'
    action :create
  end
}

log 'go-installer post install message' do
  message <<-"EOM"
Note: You must execute the following command manually.
    See #{doc_url}
    * install Go:
      $ go_install
      ...
      $ /usr/local/go/bin/go version
EOM
end
