#
# Cookbook Name:: kata-containers
# Recipe:: default
#
# Copyright 2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

platform = node['platform']

case platform
when 'centos', 'redhat'
  [
    'yum-utils',
  ].each {|pkg_name|
    resources(package: pkg_name) rescue package pkg_name do
      action :install
    end
  }

  bash 'add_kata-containers_repo' do
    code <<-"EOH"
      source /etc/os-release
      if [ -f /etc/yum.repos.d/*katacontainers*.repo ]; then
        rm /etc/yum.repos.d/*katacontainers*.repo
      fi
      yum-config-manager --add-repo "http://download.opensuse.org/repositories/home:/katacontainers:/release/CentOS_${VERSION_ID}/home:katacontainers:release.repo"
    EOH
    action :nothing
    not_if "yum repolist | grep 'katacontainers'" unless node['kata-containers']['repo']['update']
  end

  [
    'kata-runtime',
    'kata-proxy',
    'kata-shim',
  ].each {|pkg_name|
    resources(package: pkg_name) rescue package pkg_name do
      action :install
      notifies :run, 'bash[add_kata-containers_repo]', :before
    end
  }
when 'ubuntu'
  [
    'curl',
  ].each {|pkg_name|
    resources(package: pkg_name) rescue package pkg_name do
      action :install
    end
  }

  apt_get_update = 'apt-get_update'
  resources(execute: apt_get_update) rescue execute apt_get_update do
    command 'apt-get update'
    action :nothing
  end

  bash 'add_kata-containers_apt_key' do
    code <<-"EOH"
      curl -sL http://download.opensuse.org/repositories/home:/katacontainers:/release/xUbuntu_$(lsb_release -rs)/Release.key | apt-key add -
    EOH
    action :nothing
    not_if "apt-key list | grep 'katacontainers'"
  end

  bash 'add_kata-containers_apt_line' do
    code <<-"EOH"
      echo "deb http://download.opensuse.org/repositories/home:/katacontainers:/release/xUbuntu_$(lsb_release -rs)/ /" > /etc/apt/sources.list.d/kata-containers.list
    EOH
    action :nothing
    not_if { File.exist?('/etc/apt/sources.list.d/kata-containers.list') } unless node['kata-containers']['repo']['update']
    notifies :run, 'bash[add_kata-containers_apt_key]', :before
    notifies :run, "execute[#{apt_get_update}]", :immediately
  end

  [
    'kata-runtime',
    'kata-proxy',
    'kata-shim',
  ].each {|pkg_name|
    resources(package: pkg_name) rescue package pkg_name do
      action :install
      notifies :run, 'bash[add_kata-containers_apt_line]', :before
    end
  }
end
