#
# Cookbook Name:: lxcs
# Attributes:: default
#
# Copyright 2017-2021, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['lxcs']['lxc']['env']['lxc'] = {
  'LXC_AUTO' => 'true',
  'BOOTGROUPS' => 'onboot,',
  'SHUTDOWNDELAY' => '5',
  'OPTIONS' => '',
  'STOPOPTS' => '-a -A -s',
  'USE_LXC_BRIDGE' => 'false',
}
default['lxcs']['lxc']['env']['lxc-net'] = {
  'USE_LXC_BRIDGE' => 'true',
  'LXC_BRIDGE' => 'lxcbr0',
  'LXC_ADDR' => '10.0.3.1',
  'LXC_NETMASK' => '255.255.255.0',
  'LXC_NETWORK' => '10.0.3.0/24',
  'LXC_DHCP_RANGE' => '10.0.3.2,10.0.3.254',
  'LXC_DHCP_MAX' => '253',
}
default['lxcs']['lxc']['unprivileged_container'] = {
  'enabled' => false,
  'users_allow' => [],
}
# Default initial configuration file
# Content is line string's array or single string.
# 17.10 (LXC 2.1): https://discuss.linuxcontainers.org/t/lxc-2-1-has-been-released/487
default['lxcs']['lxc']['default.conf'] = \
  if node['platform_version'] >= '17.10'
    [
      'lxc.net.0.type = veth',
      'lxc.net.0.link = lxcbr0',
      'lxc.net.0.flags = up',
      'lxc.net.0.hwaddr = 00:16:3e:xx:xx:xx',
    ]
  else
    [
      'lxc.network.type = veth',
      'lxc.network.link = lxcbr0',
      'lxc.network.flags = up',
      'lxc.network.hwaddr = 00:16:3e:xx:xx:xx',
    ]
  end
# Other initial configuration files
default['lxcs']['lxc']['extra-default.conf'] = {
=begin
  # Content is line string's array or single string
  'default-br0.conf' => [
    'lxc.network.type = veth',
    'lxc.network.link = br0',
    'lxc.network.flags = up',
    'lxc.network.hwaddr = 00:16:3e:xx:xx:xx',
  ],
  'default-br0-unpriv.conf' => [
    'lxc.network.type = veth',
    'lxc.network.link = br0',
    'lxc.network.flags = up',
    'lxc.network.hwaddr = 00:16:3e:xx:xx:xx',
    'lxc.id_map = u 0 100000 65536',
    'lxc.id_map = g 0 100000 65536',
  ],
=end
}
# Content is line string's array or single string
default['lxcs']['lxc']['lxc-usernet'] = [
  # USERNAME TYPE BRIDGE COUNT
  #'alice veth lxcbr0 10',
  # ...
]

default['lxcs']['lxd']['verbose'] = false
default['lxcs']['lxd']['with_zfs'] = false
default['lxcs']['lxd']['users_allow'] = []
default['lxcs']['lxd']['init'] = {
  'enabled' => false,
  'force' => false,
  'options' => [
    #"--network-address #{node['ipaddress']}",
    #'--network-port 8443',
    #'--storage-backend dir',
  ].join(' '),
  'trust_password_vault_item' => {
=begin
    'vault' => 'lxd',
    'name' => 'trust_password',
    # single password or nested hash password path delimited by slash
    'env_context' => false,
    'key' => 'password',  # real hash path: "/password"
    # or nested hash password path delimited by slash
    #'env_context' => true,
    #'key' => 'hash/path/to/password',  # real hash path: "/#{node.chef_environment}/hash/path/to/password"
=end
  },
=begin
Init options:
    --auto
        Automatic (non-interactive) mode

Init options for non-interactive mode (--auto):
    --network-address ADDRESS
        Address to bind LXD to (default: none)
    --network-port PORT
        Port to bind LXD to (default: 8443)
    --storage-backend NAME
        Storage backend to use (zfs or dir, default: dir)
    --storage-create-device DEVICE
        Setup device based storage using DEVICE
    --storage-create-loop SIZE
        Setup loop based storage with SIZE in GB
    --storage-pool NAME
        Storage pool to use or create
    --trust-password PASSWORD
        Password required to add new clients
=end
}
default['lxcs']['lxd']['config'] = {
=begin
  # Examples
  'core.https_address' => '192.168.1.50:8443',
  'core.trust_password' => true,
  'storage.zfs_pool_name' => 'lxd',
=end
}
# Ubuntu >= 16.10 (yakkety)
default['lxcs']['lxd']['network'] = {
=begin
  # Examples
  'lxdbr0' => {
    'config' => {
      'ipv4.address' => '10.62.42.1/24',
      'ipv4.nat' => 'true',
      'ipv6.address' => 'fd00:56ad:9f7a:9800::1/64',
      'ipv6.nat' => 'true',
    },
    'managed' => 'true',
    'type' => 'bridge',
  },
  'lxdbr0' => {
    'config' => {
      'dns.mode' => 'dynamic',
      'ipv4.address' => '10.1.3.1/24',
      'ipv4.dhcp.ranges' => '10.1.3.100-10.1.3.254',
      'ipv4.nat' => 'true',
      'ipv6.address' => 'none',
    },
    'managed' => 'true',
    'type' => 'bridge',
  },
=end
}
default['lxcs']['lxd']['network_force_update'] = false
# Ubuntu <= 16.04 LTS (xenial)
default['lxcs']['lxd']['bridge'] = {
  'enabled' => false,
  'conf' => {
    'USE_LXD_BRIDGE' => 'true',
    # Bridge name
    # This is still used even if USE_LXD_BRIDGE is set to false
    # set to an empty value to fully disable
    'LXD_BRIDGE' => 'lxdbr0',
    # Update the "default" LXD profile
    'UPDATE_PROFILE' => 'true',
    # Path to an extra dnsmasq configuration file
    'LXD_CONFILE' => '',
    # DNS domain for the bridge
    'LXD_DOMAIN' => 'lxd',
    ## IPv4 address (e.g. 10.0.8.1)
    'LXD_IPV4_ADDR' => '',
    ## IPv4 netmask (e.g. 255.255.255.0)
    'LXD_IPV4_NETMASK' => '',
    ## IPv4 network (e.g. 10.0.8.0/24)
    'LXD_IPV4_NETWORK' => '',
    ## IPv4 DHCP range (e.g. 10.0.8.2,10.0.8.254)
    'LXD_IPV4_DHCP_RANGE' => '',
    ## IPv4 DHCP number of hosts (e.g. 250)
    'LXD_IPV4_DHCP_MAX' => '',
    ## NAT IPv4 traffic
    'LXD_IPV4_NAT' => 'true',
    ## IPv6 address (e.g. 2001:470:b368:4242::1)
    'LXD_IPV6_ADDR' => '',
    ## IPv6 CIDR mask (e.g. 64)
    'LXD_IPV6_MASK' => '',
    ## IPv6 network (e.g. 2001:470:b368:4242::/64)
    'LXD_IPV6_NETWORK' => '',
    ## NAT IPv6 traffic
    'LXD_IPV6_NAT' => 'false',
    # Run a minimal HTTP PROXY server
    'LXD_IPV6_PROXY' => 'true',
  },
}
default['lxcs']['lxd']['profile'] = {
=begin
  # Examples (existing profiles)
  'default' => {
    'config' => {},
    'description' => 'Default LXD profile',
    'devices' => {
      'eth0' => {
        'name' => 'eth0',
        'nictype' => 'bridged',
        'parent' => 'lxdbr0',
        'type' => 'nic',
      },
    },
  },
  'docker' => {
    'config' => {
      'linux.kernel_modules' => 'overlay, nf_nat',
      'security.nesting' => 'true',
    },
    'description' => 'Profile supporting docker in containers',
    'devices' => {
      'aadisable' => {
        'path' => '/sys/module/apparmor/parameters/enabled',
        'source' => '/dev/null',
        'type' => 'disk',
      },
      'fuse' => {
        'path' => '/dev/fuse',
        'type' => 'unix-char',
      },
    },
  },
=end
}
