minim-server Cookbook
===================

This cookbook sets up a MinimServer by Docker-compose.
You can build MinimServer Docker image and run it by `docker-compose`.

Note: do not push a Docker image including MinimServer to any public registries, because its re-distribution is not allowed by the [MinimServer license](http://minimserver.com/license.html).

## Contents

- [Requirements](#requirements)
    - [platforms](#platforms)
    - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
    - [Recipes](#recipes)
        - [minim-server::default](#minim-serverdefault)
        - [minim-server::docker-compose](#minim-serverdocker-compose)
    - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### platforms

- Debian >= 9.0
- Ubuntu >= 16.04
- CentOS,RHEL >= 7.3

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['minim-server']['Dockerfile']['FROM']`|String|Base image in the `Dockerfile`.|See `attributes/default.rb`|
|`['minim-server']['docker-compose']['autopilot']`|Hash|Autopilot configurations.|See `attributes/default.rb`|
|`['minim-server']['docker-compose']['app_dir']`|String||`"#{node['docker-grid']['compose']['app_dir']}/minim-server"`|
|`['minim-server']['docker-compose']['data_dir']`|String||`"#{node['minim-server']['docker-compose']['app_dir']}/data"`|
|`['minim-server']['docker-compose']['dot_env']`|Hash|`.env` configurations.|See `attributes/default.rb`|
|`['minim-server']['docker-compose']['config']`|Hash|`docker-compose.yml` configurations.|See `attributes/default.rb`|

## Usage

### Recipes

#### minim-server::default

This recipe does nothing.

#### minim-server::docker-compose

This recipe generates a `docker-compose.yml` for the Minim-server.

### Role Examples

- `roles/minim-server-on-docker.rb`

```ruby
name 'minim-server-on-docker'
description 'Minim-server on Docker'

run_list(
  # see https://osdn.net/projects/metasearch/scm/git/grid-chef-repo/blobs/master/roles/docker-new-repo.rb
  'role[docker]',
  'recipe[minim-server::docker-compose]',
)

#env_run_lists

#default_attributes

override_attributes(
  'minim-server' => {
    'docker-compose' => {
      'dot_env' => {
        # the official image
        # https://hub.docker.com/r/minimworld/minimserver
        'REGISTRY' => 'minimworld',
        'NAME' => 'minimserver',
        'MINIM_VER' => 'latest',  # latest-arm, latest-arm64
        # Local build
        #'REGISTRY' => 'yourname',
        #'NAME' => 'minimserver',
        #'MINIM_VER' => '0.8.5.2',
      },
      'config' => {
        'services' => {
          'minim-server' => {
            'volumes' => [
              '/path/local/media:/media:ro',
            ],
          },
        },
      },
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2018-2022, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
