#
# Cookbook Name:: minim-server
# Attributes:: default
#
# Copyright 2018-2022, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

minim_ver = '0.8.5.2'
image_name = nil
base_image = nil
download_url = nil

case node['kernel']['machine']
when 'x86_64'
  image_name = 'minimserver'
  base_image = 'java:8-jre'
  download_url = "https://jminim.com/brac/MinimServer-#{minim_ver}-linux-intel.tar.gz"
when 'armv7l'
  image_name = 'minimserver-armhf'
  base_image = 'arm32v7/openjdk:8-jre'
  download_url = "https://jminim.com/brac/MinimServer-#{minim_ver}-linux-armhf.tar.gz"
end

default['minim-server']['Dockerfile'] = {
  'FROM' => base_image,
}

default['minim-server']['docker-compose']['autopilot'] = {
  'enabled' => false,
  'log_dir' => '/var/log',
  'wait_time' => '180s',
  'docker-compose_opts' => '--no-ansi',
  #'docker-compose_opts' => '',  # for the old docker-compose
}
default['minim-server']['docker-compose']['app_dir'] = "#{node['docker-grid']['compose']['app_dir']}/minim-server"
default['minim-server']['docker-compose']['data_dir'] = "#{node['minim-server']['docker-compose']['app_dir']}/data"

default['minim-server']['docker-compose']['dot_env'] = {
  'NAME' => image_name,
  'MINIM_VER' => minim_ver,  # 0.8.5.2, 2.1, 2.1-arm, latest, latest-arm
  # archive url
  'url' => download_url,
  # already not found!
  #'url' => 'http://jminim.com/cada/MinimServer-0.8.4-linux-x64.tar.gz',
  # Internal registry context, e.g. gitlab.io.example.com:5050/images
  'REGISTRY' => 'local',  # or minimworld (official registry)
}

force_override['minim-server']['docker-compose']['config_format_version'] = '2'
version_2_config = {
  # Version 2 docker-compose format
  'version' => '2',
  'services' => {
    'minim-server' => {
      'image' => '${REGISTRY}/${NAME}:${MINIM_VER}',
      'restart' => 'always',
      'network_mode' => 'host',
      'volumes' => [
        # These volumes will be set by the minim-server::docker-compose recipe automatically.
        #"#{node['minim-server']['docker-compose']['data_dir']}:/opt/minimserver/data:rw",
      ],
    },
  },
}

node_dot_env = node['minim-server']['docker-compose']['dot_env']
unless node_dot_env['REGISTRY'] == 'minimworld'  # Official registry
  version_2_config['services']['minim-server']['build'] = {
    'context' => './',
    'args' => {
      'url' => '${url}',
    },
  }
end

default['minim-server']['docker-compose']['config'] = version_2_config
