#
# Cookbook Name:: samba-grid
# Attributes:: default
#
# Copyright 2016-2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['samba-grid']['group']['sambashare'] = {
  'gid' => nil,
  'members' => [],
}
default['samba-grid']['autopilot'] = {
  'enabled' => false,
  'log_dir' => '/var/log',
  'wait_time' => '180s',
}
default['samba-grid']['smb.conf'] = {
  'global' => {
    #'workgroup' => 'WORKGROUP',
    #'wide links' => 'yes',
    #'follow symlinks' => 'yes',
    #'unix extensions' => 'no',
    #'dos charset' => 'CP932',
  },
  'homes' => {},
  'printers' => {},
  'printD' => {},  # for [print$] section
  # Share Definitions
  # ...
}
default['samba-grid']['smbldap-tools']['smbldap.conf'] = {
  'SID' => '',
  'sambaDomain' => 'DOMSMB',
  'slaveLDAP' => 'ldap://ldap.example.com/',
  'masterLDAP' => 'ldap://ldap.example.com/',
  'ldapTLS' => '1',
  'suffix' => 'dc=example,dc=com',
  'mailDomain' => 'example.com',
}
default['samba-grid']['smbldap-tools']['smbldap_bind.conf'] = {
  'slaveDN' => 'cn=Manager,dc=example,dc=com',
  'slavePw_vault_item' => {
=begin
    'vault' => 'smbldap_bind_pws',
    'name' => 'slavePw',
    # single password or nested hash password path delimited by slash
    'env_context' => false,
    'key' => 'password',  # real hash path: "/password"
    # or nested hash password path delimited by slash
    #'env_context' => true,
    #'key' => 'hash/path/to/password',  # real hash path: "/#{node.chef_environment}/hash/path/to/password"
=end
  },
  'masterDN' => 'cn=Manager,dc=example,dc=com',
  'masterPw_vault_item' => {
=begin
    #'vault' => 'smbldap_bind_pws',
    #'name' => 'masterPw',
    #'env_context' => false,
    #'key' => 'password',
=end
  },
}
