#
# Copyright 2016-2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'docker-registry'
description 'Docker Registry'

run_list(
  'recipe[ssl_cert::ca_certs]',
  'recipe[ssl_cert::server_key_pairs]',
  'role[docker]',
  'recipe[docker-grid::registry]',
)

#env_run_lists()

#default_attributes()

ca_name = 'grid_ca'
registry_cn = 'registry.docker.example.com'

override_attributes(
  'ssl_cert' => {
    'ca_names' => [
      ca_name,
    ],
    'common_names' => [
      registry_cn,
    ],
  },
  'docker-grid' => {
    'engine' => {
      'skip_setup' => false,
    },
    'compose' => {
      'skip_setup' => false,
    },
    'registry' => {
      'with_ssl_cert_cookbook' => true,
      'ssl_cert' => {
        'common_name' => registry_cn,
      },
      'docker-compose' => {
        'config' => {
          'registry' => {
            'restart' => 'always',
            'image' => 'registry:2',
            'ports' => [
              '5000:5000',
            ],
            'environment' => {
              # These environment variables will be set by the docker-grid::registry recipe automatically.
              #'REGISTRY_HTTP_TLS_CERTIFICATE' => '/certs/domain.crt',
              #'REGISTRY_HTTP_TLS_KEY' =>         '/certs/domain.key',
              'REGISTRY_AUTH' =>                'htpasswd',
              'REGISTRY_AUTH_HTPASSWD_PATH' =>  '/auth/.htpasswd',
              'REGISTRY_AUTH_HTPASSWD_REALM' => 'Registry Realm',
            },
            'volumes' => [
              # These volumes will be set by the docker-grid::registry recipe automatically.
              #"#{server_cert_path(node['docker-grid']['registry']['ssl_cert']['common_name'])}:/certs/domain.crt:ro",
              #"#{server_key_path(node['docker-grid']['registry']['ssl_cert']['common_name'])}:/certs/domain.key:ro",
              './auth:/auth',
            ],
          },
        },
      },
    },
  },
)

