#
# Copyright 2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'minim-server-on-docker'
description 'Minim Server on Docker'

run_list(
  'role[docker]',
  'recipe[minim-server::docker-compose]',
)

#env_run_lists

default_attributes(
)

override_attributes(
  'minim-server' => {
    'docker-compose' => {
      'dot_env' => {
        # the official image
        # https://hub.docker.com/r/minimworld/minimserver
        'REGISTRY' => 'minimworld',
        'NAME' => 'minimserver',
        'MINIM_VER' => 'latest',  # latest-arm, latest-arm64
        # Local build
        #'REGISTRY' => 'yourname',
        #'NAME' => 'minimserver',
        #'MINIM_VER' => '0.8.5.2',
      },
    },
  },
)
