#
# Cookbook Name:: krb5
# Recipe Spec:: client_spec
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require_relative '../spec_helper'

describe 'krb5::client' do
  let(:chef_run_on_debian) {
    ChefSpec::SoloRunner.new(platform: 'debian', version: '7.6') {|node|
      node.set['krb5']['libdefaults']['default_realm'] = 'GRID.EXAMPLE.COM'
    }.converge(described_recipe)
  }

  it 'installs krb5-user on debian family.' do
    expect(chef_run_on_debian).to install_package('krb5-user')
  end

  it 'renders /etc/krb5.conf on debian family.' do
    expect(chef_run_on_debian).to \
      render_file('/etc/krb5.conf').
        with_content(%r|^\s+default_realm\s+=\s+GRID\.EXAMPLE\.COM$|)
  end

  let(:chef_run_on_rhel) {
    ChefSpec::SoloRunner.new(platform: 'centos', version: '7.0') {|node|
      node.set['krb5']['libdefaults']['default_realm'] = 'GRID.EXAMPLE.COM'
    }.converge(described_recipe)
  }

  it 'installs krb5-workstation on rhel family.' do
    expect(chef_run_on_rhel).to install_package('krb5-workstation')
  end

  it 'renders /etc/krb5.conf on rhel family.' do
    expect(chef_run_on_rhel).to \
      render_file('/etc/krb5.conf').
        with_content(%r|^\s+default_realm\s+=\s+GRID\.EXAMPLE\.COM$|)
  end
end

