/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayerplugin.renderer.pianoroll;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class NoteObject {
    protected final Rectangle2D.Float rect = new Rectangle2D.Float();
    protected boolean visible;
    protected boolean noteOn;
    public volatile int channel;
    public volatile int noteNo;
    private volatile Color activeColor = Color.RED;
    private volatile Color deactiveColor = this.activeColor.darker();
    public volatile int circle;
    private long start = 0L;

    public NoteObject() {
        this.reset();
    }

    public void reset() {
        this.rect.setRect(0.0f, 0.0f, 0.0f, 0.0f);
        this.visible = false;
        this.noteOn = false;
        this.channel = 0;
        this.noteNo = 0;
    }

    public void noteOn(int sx, int sy) {
        this.rect.setRect(sx, sy, 1.0f, 2.0f);
        this.circle = 16;
        this.visible = true;
        this.noteOn = true;
        this.start = System.currentTimeMillis();
    }

    public void noteOff() {
        this.noteOn = false;
    }

    public void update() {
        if (this.visible) {
            long now = System.currentTimeMillis();
            float delta = 1.4f;
            this.start = now;
            this.rect.x -= delta;
            if (this.circle > 0) {
                --this.circle;
            }
            if (this.noteOn) {
                this.rect.width += delta;
            } else if (this.rect.x + this.rect.width < 0.0f) {
                this.reset();
            }
        }
    }

    public synchronized void render(Graphics2D g) {
        if (this.visible) {
            if (this.noteOn) {
                g.setColor(this.activeColor);
            } else {
                g.setColor(this.deactiveColor);
            }
            g.fill(this.rect);
            if (this.circle > 0) {
                g.setColor(this.activeColor);
                g.drawOval(472, (int)this.rect.y - (this.circle >> 1), this.circle, this.circle);
            }
        }
    }

    public synchronized void setColor(Color c) {
        this.activeColor = c;
        this.deactiveColor = c.darker().darker();
    }
}

