/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayerplugin.renderer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.xmlmodule.deviceinfo.Instrument;
import org.rz.midiplayerplugin.renderer.DefaultRenderer;
import org.rz.midiplayerplugin.renderer.MidiChannel;

class TrackRenderer {
    private final Context context;
    private final int channel;
    private Image offscreen;
    private Graphics2D ofsG;
    private Image track;
    private Image font;
    private MidiChannel midiChannel;
    private final Color pianoRollColor;
    private static final Color[] LV_COLOR = new Color[]{new Color(5077754), new Color(1770202)};

    TrackRenderer(Context ctx, int ch, MidiChannel midiCh, Canvas screen, Image trackImage, Image fontImage, Color pianoRollColor_) {
        this.context = ctx;
        this.channel = ch;
        this.midiChannel = midiCh;
        this.offscreen = screen.createImage(trackImage.getWidth(null), trackImage.getHeight(null));
        this.ofsG = (Graphics2D)this.offscreen.getGraphics();
        this.font = fontImage;
        this.track = trackImage;
        this.pianoRollColor = pianoRollColor_;
    }

    void dispose() {
        if (this.ofsG != null) {
            try {
                this.ofsG.dispose();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.ofsG = null;
        }
        if (this.offscreen != null) {
            try {
                this.offscreen.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.offscreen = null;
        }
        this.font = null;
    }

    void render(Graphics2D g, int x, int y) {
        this.ofsG.drawImage(this.track, 0, 0, null);
        int[] cc = this.midiChannel.cc;
        int lv = this.midiChannel.level;
        Instrument patch = this.midiChannel.instrument;
        Graphics2D tg = this.ofsG;
        tg.drawImage(this.track, 0, 0, null);
        this.renderChNo(tg, this.channel + 1);
        this.renderChColor(tg, this.channel);
        this.renderPatch(tg, patch);
        this.renderLv(tg, 122, lv, 127);
        this.renderLv(tg, 143, cc[7], 127);
        this.renderLvH(tg, 164, cc[10], 127);
        this.renderLv(tg, 185, cc[11], 127);
        this.renderLvH(tg, 206, this.midiChannel.pitchBend, 16383);
        this.renderLv(tg, 227, cc[91], 127);
        this.renderLv(tg, 248, cc[93], 127);
        this.renderLv(tg, 269, cc[94], 127);
        g.drawImage(this.offscreen, x, y, null);
        this.midiChannel.level = Math.max(this.midiChannel.level - 2, 0);
    }

    private void renderLv(Graphics2D g, int x, int value, int max) {
        int r = value * 16 / max;
        Color[] c = LV_COLOR;
        for (int i = 0; i < r; ++i) {
            g.setColor(c[i & 1]);
            g.fillRect(x + i + 2, 14, 1, 7);
        }
    }

    private void renderLvH(Graphics2D g, int x, int value, int max) {
        int v = value - (max + 1) / 2;
        int r = v * 16 / max;
        Color[] c = LV_COLOR;
        g.setColor(c[1]);
        g.fillRect(x + 8 + 2, 14, 1, 7);
        if (v < 0) {
            for (int i = r; i < 0; ++i) {
                g.setColor(c[i & 1]);
                g.fillRect(x + 8 + i + 2, 14, 1, 7);
            }
        } else {
            for (int i = 0; i < r; ++i) {
                g.setColor(c[i & 1]);
                g.fillRect(x + 8 + i + 2, 14, 1, 7);
            }
        }
    }

    private void renderPatch(Graphics2D g, Instrument p) {
        int dx = 20;
        int dy = 2;
        g.setClip(20, 2, 96, 20);
        String[] name = p.getName().split("<>");
        for (int i = 0; i < name.length; ++i) {
            DefaultRenderer.drawText(g, this.font, name[i], dx, dy);
            dy += 10;
        }
        g.setClip(null);
    }

    private void renderChNo(Graphics2D g, int ch) {
        int dx = 2;
        int dy = 7;
        if (ch < 10) {
            DefaultRenderer.drawText(g, this.font, String.valueOf(0), dx, dy);
            DefaultRenderer.drawText(g, this.font, String.valueOf(ch), dx + 6, dy);
        } else {
            DefaultRenderer.drawText(g, this.font, String.valueOf(ch / 10), dx, dy);
            DefaultRenderer.drawText(g, this.font, String.valueOf(ch % 10), dx + 6, dy);
        }
    }

    private void renderChColor(Graphics2D g, int ch) {
        g.setColor(this.pianoRollColor);
        g.fillRect(117, 4, 3, 16);
    }
}

