#define CM
#ifndef CM
/**
 * Nyarudinoのスケッチシステムを使う場合の実装
 */
#include "boot/sketch.h"
#include "NyLPC_uipService.h"

void setup(void)
{
	//EthernetAddressのセット
	NyLPC_TEtherMacAddr_t mac=NyLPC_TEtherMacAddr_pack(0x00,0x12,0x13,0x10,0x15,0x11);
    //uipサービスの初期化
	NyLPC_cUipService_initialize(&mac);
}
static char dummy[2000];


void recv_loop(void)
{
	//IPアドレスの設定
	NyLPC_TIpv4Addr_t ipaddr=NyLPC_TIpv4Addr_pack(192,168,128,201);
	NyLPC_TIpv4Addr_t netmask=NyLPC_TIpv4Addr_pack(255,255,255,0);
	NyLPC_TIpv4Addr_t gateway=NyLPC_TIpv4Addr_pack(192,168,128,254);
	NyLPC_TcTcpListener_t li;
	NyLPC_TcTcpSocket_t s;
	NyLPC_TUInt32 sl;
	int i,i2;
	char* d;
	for(i=0;i<2000;i++){
		dummy[i]='0'+i%10;
	}
	NyLPC_cUipService_start(&ipaddr,&netmask,&gateway); //Uipの開始
	NyLPC_cTcpListener_initialize(23,3,&li); 	//リスナ生成
	NyLPC_cUipService_addListener(&li);			//リスナadd
	//ソケット生成
	NyLPC_cTcpSocket_initialize(&s);
	for(;;){
		//listen処理
		if(!NyLPC_cTcpListener_listen(&li,&s,1000/portTICK_RATE_MS)){
			continue;
		}
		//送信側を閉じる。
		NyLPC_cTcpSocket_send_close(&s);
		//とりあえずデータ受信して閉じる。
		i=0;
		while(i<1024*1024){
			if(NyLPC_cTcpSocket_recv(&s,&d,&sl,10000/portTICK_RATE_MS)){
//				NyLPC_cTcpSocket_recv_fin(&s);
				i+=sl;
			}else{
				NyLPC_cTcpSocket_recv_close(&s);
				goto end;
			}
		}
		NyLPC_cTcpSocket_recv_close(&s);
		end:;
	}
}

void loop(void)
{
	loopback();
	for(;;){}
}
#endif
