/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#include "NyLPC_protected_sdfsService.h"
/**********************************************************************
 *
 * NyLPC_TcSdService class
 *
 **********************************************************************/

/** Service instance*/
NyLPC_TcSdService_t* _NyLPC_TcSdFsService_inst=NULL;
static NyLPC_TcSdService_t _service_instance;


NyLPC_TBool NyLPC_cSdService_initialize()
{
	//未初期化である事  - Service must be uninitialized.
	NyLPC_Assert(!NyLPC_TcSdFsService_isInitService());

	_service_instance.mutex= xSemaphoreCreateMutex();
	if(_service_instance.mutex==NULL){
		NyLPC_OnErrorGoto(ERROR_FAILED);
	}
	_service_instance._last_err=FR_NOT_READY;
	_service_instance._locked_object=NULL;
	_NyLPC_TcSdFsService_inst=&_service_instance;
	return NyLPC_TBool_TRUE;
ERROR_FAILED:
	return NyLPC_TBool_FALSE;
}


NyLPC_TBool NyLPC_cSdService_prepareSD()
{
	NyLPC_Assert(NyLPC_TcSdFsService_isInitService());

	//マウントされていないときだけマウント - Mount when no mounted.
	if(_NyLPC_TcSdFsService_inst->_last_err==FR_NOT_READY){
		_NyLPC_TcSdFsService_inst->_last_err=f_mount(0,&_NyLPC_TcSdFsService_inst->_fs_object);
		if(_NyLPC_TcSdFsService_inst->_last_err!=FR_OK){
			NyLPC_OnErrorGoto(ERROR_FAILED);
		}
	}
	return NyLPC_TBool_TRUE;
ERROR_FAILED:
	return NyLPC_TBool_FALSE;
}
