
using MiMic.CsApi.LPC1769;

namespace MiMic.CsApi.LPC1769
{
	public class MbedM3:LPC1769
	{
		public static class PINNAME
		{
			//Left side
			public static PinId SPI1MOSI=LPC1769.P0[9];
			public static PinId SPI1MISO=LPC1769.P0[8];
			public static PinId SPI1SCK =LPC1769.P0[7];
			public static PinId GPIO    =LPC1769.P0[6];
			public static PinId UART1TX =LPC1769.P0[0];
			public static PinId I2C1SDA =LPC1769.P0[0];
			public static PinId UART1RX =LPC1769.P0[1];
			public static PinId I2C1SCL =LPC1769.P0[1];
			public static PinId SPI2MODI=LPC1769.P0[18];
			public static PinId SPI2MISO=LPC1769.P0[17];
			public static PinId SPI2SCK =LPC1769.P0[15];
			public static PinId UART2TX =LPC1769.P0[15];
			public static PinId SPI2SCL =LPC1769.P0[15]; //SPISCL->SPISCK?
			public static PinId UART2RX =LPC1769.P0[16];
			public static PinId AIN0    =LPC1769.P0[23];
			public static PinId AIN1    =LPC1769.P0[24];
			public static PinId AIN2    =LPC1769.P0[25];
			public static PinId AIN3    =LPC1769.P0[26];
			public static PinId AOUT    =LPC1769.P0[26];
			public static PinId AIN4    =LPC1769.P0[30];
			public static PinId AIN5    =LPC1769.P0[31];
			//Right side
			public static PinId USBDP    =LPC1769.P0[29];
			public static PinId USBDM    =LPC1769.P0[30];
			public static PinId CANRD    =LPC1769.P0[4];
			public static PinId CANTD    =LPC1769.P0[5];
			public static PinId UART3TX  =LPC1769.P0[10];
			public static PinId I2C2SDA  =LPC1769.P0[10];
			public static PinId UART3RX  =LPC1769.P0[11];
			public static PinId I2C2SCL  =LPC1769.P0[10];
			public static PinId PWMOUT0  =LPC1769.P2[0];
			public static PinId PWMOUT1  =LPC1769.P2[1];
			public static PinId PWMOUT2  =LPC1769.P2[2];
			public static PinId PWMOUT3  =LPC1769.P2[3];
			public static PinId PWMOUT4  =LPC1769.P2[4];
			public static PinId PWMOUT5  =LPC1769.P2[5];
		};
		/**
		 * Mbedのピン名に対応するピン識別子である。配列の番号は、Mbed付属のチートシートに一致する。
		 * 要素は、LPC1769のピン識別子を参照する。
		 * @name MbedM3#PIN
		 * @constant
		 * @field
		 * @example
		 * var mcu=new MbedM3.Mcu(“192.168.0.39”);
		 * var adpin=mcu.getPin(MbedM3.PINNAME.AIN0,"AD");//bind AIN0 with AD function
		 */
		public static PinId[] PIN={
			null,null,null,null,null,//0,1,2,3,4
			LPC1769.P0[9],//5
			LPC1769.P0[8],//6
			LPC1769.P0[7],//7
			LPC1769.P0[6],//8
			LPC1769.P0[0],//9
			LPC1769.P0[1],//10
			LPC1769.P0[18],//11
			LPC1769.P0[17],//12
			LPC1769.P0[15],//13
			LPC1769.P0[16],//14
			LPC1769.P0[23],//15
			LPC1769.P0[24],//16
			LPC1769.P0[25],//17
			LPC1769.P0[26],//18
			LPC1769.P1[30],//19
			LPC1769.P1[31],//20
			LPC1769.P2[5],//21
			LPC1769.P2[4],//22
			LPC1769.P2[3],//23
			LPC1769.P2[2],//24
			LPC1769.P2[1],//25
			LPC1769.P2[0],//26
			LPC1769.P0[11],//27
			LPC1769.P0[10],//28
			LPC1769.P0[5],//29
			LPC1769.P0[4]//30
		};
		/**
		 * MbedのLEDに接続されたピン識別子である。
		 * 要素は、LPC1769のピン識別子を参照する。
		 * @name MbedM3#LED
		 * @constant
		 * @field
		 * @example
		 * var mcu=new MbedM3.Mcu(“192.168.0.39”);
		 * var pin=mcu.getPin(MbedM3.LED[0],"GPIO");//bind LEDPIN with gpio function
		 */
		
		public static PinId[] LED
		={
			LPC1769.P1[18],
			LPC1769.P1[20],
			LPC1769.P1[21],
			LPC1769.P1[23]
		};

	}

}

