////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) Microsoft Corporation.  All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <stddef.h>
#include <tinyhal.h>

////////////////////////////////////////////////////////////////////////////////

static void RuntimeFault( int szText )
{
    lcd_printf("\014ERROR:\r\n%d\r\n", szText );
    debug_printf( "ERROR: %d\r\n", szText );

    // let watchdog take over
    CPU_Halt();
}

void *operator new(size_t)
{
    RuntimeFault( 1 );

    return NULL;
}

void *operator new[](size_t)
{
    RuntimeFault( 2);

    return NULL;
}

void operator delete (void*)
{
    RuntimeFault( 3 );
}

void operator delete[] (void*)
{
    RuntimeFault(4 );
}

////////////////////////////////////////////////////////////////////////////////
