﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using NT2chCtrl.html.js;

namespace NT2chCtrl
{
    public class DebugMemory
    {
        public string Scope { get; set; }
        public string Name { get; set; }
        public string Type { get; set; }
        public string Value { get; set; }

        public static DebugMemory createInstance(string name, JsVariant var, bool local)
        {
            DebugMemory mem = new DebugMemory();

            mem.Scope = local ? "local" : "global";
            mem.Name = name;
            if (var is JsNullValue)
            {
                mem.Type = "Null";
                mem.Value = "null";
            }
            else if (var is JsUndefValue)
            {
                mem.Type = "Undefined";
                mem.Value = "undefined";
            }
            else if(var is JsBooleanValue){
                mem.Type = "Bool";
                mem.Value = var.getBooleanValue().getValue() ? "true" : "false";
            }
            else if(var is JsNumberValue){
                mem.Type = "Number";
                if(((JsNumberValue)var).IsNaN())
                    mem.Value = "NaN";
                else
                    mem.Value = var.getStringValue().getValue();
            }
            else if (var is JsStringValue)
            {
                mem.Type = "Text";
                mem.Value = var.getStringValue().getValue();
            }
            else if (var is JsDOMValue)
            {
                mem.Type = "DOM";
                mem.Value = var.getStringValue().getValue();
            }
            else
            {
                mem.Type = "Unknown Type";
                mem.Value = "---";
            }
            return mem;
        }

    }
}
