﻿using NT2chObject;
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Controls;
using System.Windows.Documents;

namespace NT2chCtrl
{
    partial class NTResViewPanel
    {
        private void setTitle(IThread ithread)
        {
            StackPanel sp = new StackPanel();
            sp.Orientation = Orientation.Horizontal;
            string title = ithread.getTitle();
            sp.Children.Add(new TextBlock(new Run(title+" ")));
            IBoard iboard = ithread.getBoard();
            string boardName;
            if (iboard != null)
            {
                boardName = iboard.getName();
                if (boardName != null && boardName.Length > 0)
                {
                    Hyperlink hl = new Hyperlink(new Run("(" + boardName + ")"));
                    sp.Children.Add(new TextBlock(hl));
                    hl.Tag = iboard;
                    hl.Click += hl_Click;
                }
            }
            mLabelThreadTitle.Content = sp;
        }

        void hl_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            Hyperlink hl = sender as Hyperlink;
            if (hl == null)
                return;

            IBoard iboard = hl.Tag as IBoard;
            if (iboard == null)
                return;

            mCommand.TryToOpenBoard(iboard);
            
        }

    }
}
