﻿using NT2chObject;
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Controls;

namespace NT2chCtrl
{
    /**
     * このファイルは編集しないで下さい。
     * 
     */
    public partial class NTResViewPanel : UserControl, IResView
    {
        private static IUtil mUtil;
        private static ICommand mCommand;
        //アプリケーションフレームワークが呼び出します。
        //ユーティリティ関数を設定します。
        public void OnInitApplicationInterface(ICommand command, IUtil util)
        {
            mCommand = command;
            mUtil = util;
            //initParam();
        }
        public static IUtil getUtil()
        {
            return mUtil;
        }

        public static ICommand getCommand()
        {
            return mCommand;
        }

        private static Dictionary<PREF_PARAM, object> mDictPreference;
        private static Dictionary<PREF_PARAM, object> getDict()
        {
            if(mUtil == null)
                return null;
            if(mDictPreference == null)
                mDictPreference = mCommand.GetPreference();
            return mDictPreference;
        }

        public bool getTextSelMode()
        {
            object o;
            Dictionary<PREF_PARAM, object> dict = getDict();
            if (!dict.TryGetValue(PREF_PARAM.RES_VIEW_TEXTSEL_MODE, out o))
                return false;
            bool? selMode = o as bool?;
            if (selMode.HasValue)
                return (bool)selMode;
            return false;
        }

        public static string getResFontTypeface()
        {
            object o;
            Dictionary<PREF_PARAM, object> dict = getDict();
            if (!dict.TryGetValue(PREF_PARAM.RES_VIEW_FONT_TYPEFACE, out o))
                return null;
            string typeface = o as string;
            return typeface;
        }
        public static string getResAAFontTypeface()
        {
            object o;
            Dictionary<PREF_PARAM, object> dict = getDict();
            if (!dict.TryGetValue(PREF_PARAM.RES_VIEW_AA_FONT_TYPEFACE, out o))
                return null;
            string typeface = o as string;
            return typeface;
        }
        public static string [] getAAStringList()
        {
            object o;
            Dictionary<PREF_PARAM, object> dict = getDict();
            if (!dict.TryGetValue(PREF_PARAM.RES_VIEW_AA_STRING_LIST, out o))
                return null;
            string[] aaList = o as string[];
            return aaList;
        }

        public static bool testAsciiArt(string source)
        {
            if (source == null || source.Length == 0)
                return false;

            string[] aaData = getAAStringList();
            if (aaData == null)
                return false;

            foreach (string aa in aaData)
            {
                if (0 <= source.IndexOf(aa))
                    return true;
            }
            return false;
        }

    }
}
