﻿using NT2chObject;
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Documents;
using System.Windows.Media;

namespace NT2chCtrl
{
    class ResViewPopup : Popup
    {
        public enum CLEAR_POPUP
        {
                ALL,
                LEAVE_ONE
        }
        static Stack<ResViewPopup> mPopupStack = new Stack<ResViewPopup>();

        //private ResViewUI mUI;
        private ResListAdapter mAdapter;

        public ResViewPopup(ResListAdapter adapter, 
        FlowDocument doc, double maxWidth, double maxHeight, double zoom, bool textSelMode)
            : base()
        {
            //mUI = ui;
            mAdapter = adapter;
            Grid grid = new Grid();
            grid.Background = new SolidColorBrush(Colors.Beige);
            FlowDocumentScrollViewer fdsv = new FlowDocumentScrollViewer();
            
            fdsv.Document = doc;
            fdsv.MaxHeight = maxHeight;
            fdsv.MaxWidth = maxWidth;
            fdsv.Zoom = zoom;
            fdsv.IsSelectionEnabled = textSelMode;
            this.Child = grid;
            grid.Children.Add(fdsv);
            addStack();

        }




        public ResViewPopup(ResListAdapter adapter, IThread ithread, IRes ires)
            : base()
        {
           mAdapter = adapter;
           List<object> param = new List<object>(2);
           param.Add(ithread);
           param.Add(ires);

           StackPanel panel = new StackPanel();
           panel.Background = new SolidColorBrush(Colors.White);
           
           ListBoxItem item1 = new ListBoxItem();
           StackPanel sp = new StackPanel();
           item1.Content = sp;
           item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
           if (!ires.getAttribute(RES_ATTRIBUTE.BOOKMARK))
           {
               sp.Children.Add(new TextBlock(new Run("ブックマークを追加")));
               sp.MouseLeftButtonDown += addBookmark_MouseLeftButtonDown;
           }
           else
           {
               sp.Children.Add(new TextBlock(new Run("ブックマークを削除")));
               sp.MouseLeftButtonDown += delBookmark_MouseLeftButtonDown;
           }
           
           item1.MouseEnter += ResNumItem_MouseEnter;
           item1.MouseLeave += ResNumItem_MouseLeave;
           sp.Tag = param;
           panel.Children.Add(item1);

           sp = new StackPanel();
           sp.Children.Add(new TextBlock(new Run("このレスに返信")));
           item1 = new ListBoxItem();
           item1.Content = sp;
           item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
           item1.MouseEnter += ResNumItem_MouseEnter;
           item1.MouseLeave += ResNumItem_MouseLeave;
           sp.MouseLeftButtonDown += replyMsg_MouseLeftButtonDown;
           sp.Tag = param;
           panel.Children.Add(item1);
           sp = new StackPanel();
           sp.Children.Add(new TextBlock(new Run("このレスに引用して返信")));
           item1 = new ListBoxItem();
           item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
           item1.Content = sp;
           item1.MouseEnter += ResNumItem_MouseEnter;
           item1.MouseLeave += ResNumItem_MouseLeave;
           sp.MouseLeftButtonDown += quoteMsg_MouseLeftButtonDown;
           sp.Tag = param;
           panel.Children.Add(item1);
           sp = new StackPanel();
           sp.Children.Add(new TextBlock(new Run("このレスからNGを抽出")));
           item1 = new ListBoxItem();
           item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
           item1.Content = sp;
           item1.MouseEnter += ResNumItem_MouseEnter;
           item1.MouseLeave += ResNumItem_MouseLeave;
           sp.MouseLeftButtonDown += extractNgword_MouseLeftButtonDown;
           sp.Tag = param;
           panel.Children.Add(item1);

           Border border = new Border();
           border.BorderThickness = new System.Windows.Thickness(1);
           border.BorderBrush = new SolidColorBrush(Colors.DarkGray);
           border.CornerRadius = new System.Windows.CornerRadius(2);
           border.Child = panel;
           this.Child = border;

            addStack();
       }



       void ResViewPopup_MouseLeave(object sender, System.Windows.Input.MouseEventArgs e)
       {
           try
           {
               ResViewPopup p = mPopupStack.Peek();
               if (p.Equals(this))
               {
                   p = mPopupStack.Pop();
                   p.IsOpen = false;
                   //break;
               }
           }
           catch// (Exception ex)
           {
               //NTDebug.l(ex.Message);
           }
       }

       void ResViewPopup_MouseEnter(object sender, System.Windows.Input.MouseEventArgs e)
       {
           ClearTo(this);
           //throw new NotImplementedException();
       }

       void ResViewPopup_LostFocus(object sender, System.Windows.RoutedEventArgs e)
       {
           //throw new NotImplementedException();
           ClearTo2(this);
       }

       void ResViewPopup_GotFocus(object sender, System.Windows.RoutedEventArgs e)
       {
           ClearTo(this);

           //throw new NotImplementedException();
       }

       public void addStack()
       {
           mPopupStack.Push(this);
           StaysOpen = true;
           Placement = PlacementMode.Mouse;
           IsOpen = true;
           this.GotFocus += ResViewPopup_GotFocus;
           this.LostFocus += ResViewPopup_LostFocus;
           this.MouseEnter += ResViewPopup_MouseEnter;
           this.MouseLeave += ResViewPopup_MouseLeave;
       }

       public static void ClearAll(CLEAR_POPUP clear)
       {
           if ((clear == CLEAR_POPUP.LEAVE_ONE) && (mPopupStack.Count < 2))
               return;

           try
           {
               while (true)
               {
                   ResViewPopup p = mPopupStack.Pop();
                   p.IsOpen = false;
               }
           }
           catch// (InvalidOperationException e)
           {
               //NTDebug.l(e.Message);
           }
       }
       public static void ClearTo2(ResViewPopup popup)
       {
           try
           {
               while (true)
               {
                   ResViewPopup p = mPopupStack.Peek();
                   if (p.Equals(popup))
                   {
                       p = mPopupStack.Pop();
                       p.IsOpen = false;
                       break;
                   }
                   p = mPopupStack.Pop();
                   p.IsOpen = false;
               }
               mPopupStack.Peek().Focus();
           }
           catch// (InvalidOperationException e)
           {
               //NTDebug.l(e.Message);
           }
       }

       public static void ClearTo(ResViewPopup popup)
       {

           try
           {
               while (true)
               {
                   ResViewPopup p = mPopupStack.Peek();
                   if (p.Equals(popup))
                       break;
                   p = mPopupStack.Pop();
                   p.IsOpen = false;
               }
               mPopupStack.Peek().Focus();
           }
           catch// (InvalidOperationException e)
           {
               //NTDebug.l(e.Message);
               return;
           }

       }

       void ResNumItem_MouseLeave(object sender, System.Windows.Input.MouseEventArgs e)
       {
           ListBoxItem item = sender as ListBoxItem;
           if (item == null)
               return;

           item.Background = new SolidColorBrush(Colors.White);
       }

       void ResNumItem_MouseEnter(object sender, System.Windows.Input.MouseEventArgs e)
       {
           ListBoxItem item = sender as ListBoxItem;
           if (item == null)
               return;

           item.Background = new SolidColorBrush(Colors.MistyRose);
       }
       void addBookmark_MouseLeftButtonDown(object sender, RoutedEventArgs e)
       {
           IThread ithread;
           IRes ires;
           if (!extractParam(sender, out ithread, out ires))
               return;
           mAdapter.addBookmark(ithread, ires, true);
           
       }
       void delBookmark_MouseLeftButtonDown(object sender, RoutedEventArgs e)
       {
           IThread ithread;
           IRes ires;
           if (!extractParam(sender, out ithread, out ires))
               return;
           mAdapter.removeBookmark(ithread, ires, true);
       }
       void replyMsg_MouseLeftButtonDown(object sender, RoutedEventArgs e)
       {
           IThread ithread;
           IRes ires;
           if (!extractParam(sender, out ithread, out ires))
               return;
           int seqNo = ires.getSequenceNo();
           string message = ">>" + seqNo.ToString() + "\n";
           NTResViewPanel.getCommand().WriteMessage(ithread, message);
       }
       /*void jumpResMsg_MouseLeftButtonDown(object sender, RoutedEventArgs e)
       {
           IThread ithread;
           IRes ires;
           if (!extractParam(sender, out ithread, out ires))
               return;
           int seqNo = ires.getSequenceNo();
           ClearAll(CLEAR_POPUP.ALL);
           mAdapter.JumpTo(seqNo);
       }*/

       void quoteMsg_MouseLeftButtonDown(object sender, RoutedEventArgs e)
       {
           IThread ithread;
           IRes ires;
           if (!extractParam(sender, out ithread, out ires))
               return;
           int seqNo = ires.getSequenceNo();
           StringBuilder sb = new StringBuilder(128);
           sb.Append(">>").Append(seqNo.ToString()).Append('\n');


           NTResViewPanel.getCommand().WriteMessage(ithread, sb.ToString());
       }

       void extractNgword_MouseLeftButtonDown(object sender, RoutedEventArgs e)
       {
           IThread ithread;
           IRes ires;
           if (!extractParam(sender, out ithread, out ires))
               return;
           NTResViewPanel.getCommand().ShowNgwordDialog(ires);
       }

       private bool extractParam(object sender, out IThread ithread, out IRes ires)
       {
           ithread = null;
           ires = null;

           StackPanel item = sender as StackPanel;
           if (item == null)
               return false;

           List<object> list = item.Tag as List<object>;
           if (list == null || list.Count != 2)
               return false;

           ithread = list[0] as IThread;
           ires = list[1] as IRes;

           return (ithread != null && ires != null);
       }

    }
}
