﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Input;

namespace NT2chCtrl
{
    public partial class UIElementListPanel : Panel
    {
        private static double DEFAULT_ITEM_HEIGHT = 200;
        private static double SCRILL_CHANGE_VALUE = 10;

        enum SCROLL_STATE
        {
            NONE, CURSOR_UP, 
            CURSOR_DOWN, EXPLICIT,
            SKIP
        }

        SCROLL_STATE mScrollState = SCROLL_STATE.EXPLICIT;

        IUIElementListAdapter mAdapter = null;
        ScrollBar mScrollbar = null;
        Size mSavedPanelSize;
        double mCurrentScrollPos;
        int mItemCount;

        ScrollItemHeight mScrollHeight = new ScrollItemHeight();


        public interface IUIElementListAdapter
        {
            int getCount();
            UIElement getElement(int pos, UIElement convertElement);
        }

       
        public void init()
        {
            this.PreviewMouseWheel += UIElementListPanel_PreviewMouseWheel;
            this.PreviewKeyDown += UIElement_PreviewKeyDown;

#if DOTNET45

            this.TouchDown += UIElementListPanel_TouchDown;
            this.TouchUp += UIElementListPanel_TouchUp;
            this.TouchMove += UIElementListPanel_TouchMove;
            this.TouchEnter += UIElementListPanel_TouchEnter;
            this.TouchLeave += UIElementListPanel_TouchLeave;
#endif
        }


        //int test = 0 ;


        void UIElement_PreviewKeyDown(object sender, System.Windows.Input.KeyEventArgs e)
        {

            if (e.Key == System.Windows.Input.Key.Down)
            {
                setScrollValue(mCurrentScrollPos + mScrollbar.SmallChange);
                e.Handled = true;
                
            }
            else if (e.Key == System.Windows.Input.Key.Up)
            {
                setScrollValue(mCurrentScrollPos - mScrollbar.SmallChange);
                e.Handled = true;
               
            }
            else if (e.Key == System.Windows.Input.Key.PageUp)
            {
                setScrollValue(mCurrentScrollPos - mScrollbar.LargeChange);
                e.Handled = true;
            }
            else if (e.Key == System.Windows.Input.Key.PageDown)
            {
                setScrollValue(mCurrentScrollPos + mScrollbar.LargeChange);
                e.Handled = true;
            }
        }

        void UIElementListPanel_PreviewMouseWheel(object sender, System.Windows.Input.MouseWheelEventArgs e)
        {            
            mCurrentScrollPos -= e.Delta;
            setScrollValue(mCurrentScrollPos);
        }

        public void setAdapter(IUIElementListAdapter adapter, int scrollTo)
        {
            mAdapter = adapter;

            initData(scrollTo);
        }

        public int getCurrentPosition()
        {
            int position;
            double itemOffset;
            if (!mScrollHeight.tryGetItemPosition(this.mCurrentScrollPos,
                          out position, out itemOffset))
                return -1;
            return position;
        }

        public void InvalidateItems()
        {
            foreach (UIElement element in base.InternalChildren)
            {
                ScrollBar sb = element as ScrollBar;
                if (sb != null)
                {
                    continue;
                }
                Grid grid = element as Grid;
                if (grid != null && grid.Children.Count > 0)
                {
                    grid.Children.Clear();
                }
            }
            setScrollItemPosition(-1);
        }
        
        void initData(int scrollTo)
        {
            if (mAdapter == null)
                return;

            this.ClipToBounds = true;


            int cnt = mAdapter.getCount();
            mItemCount = cnt;
            //mCurrentScrollPos = scrollTo * DEFAULT_ITEM_HEIGHT;

            mScrollHeight.initHeightArray(cnt);

            UIElementCollection col = base.InternalChildren;
            col.Clear();

            if (mScrollbar == null)
            {
                mScrollbar = new ScrollBar();
                mScrollbar.Visibility = System.Windows.Visibility.Visible;
                mScrollbar.ValueChanged += mScrollbar_ValueChanged;
            }
            
            col.Add(mScrollbar);

            for (int i = 0; i < cnt; i++)
            {
                UIElement element = new Grid();// mAdapter.getElement(i, null);
                col.Add(element);
            }
            //mScrollState = SCROLL_STATE.EXPLICIT;
            mScrollbar.Maximum = mScrollHeight.getTotalHeight();
            mScrollbar.Minimum = 0;
            mScrollbar.Value = mCurrentScrollPos;
            mScrollbar.SmallChange = SCRILL_CHANGE_VALUE;
            mScrollbar.LargeChange = DEFAULT_ITEM_HEIGHT;
            //setScrollItemPosition(scrollTo);
        }

        public void setScrollItemPosition(int itemPosition)
        {
            mScrollState = SCROLL_STATE.EXPLICIT;
            if (itemPosition >= 0)
            {
                mCurrentScrollPos = mScrollHeight.getScrollOffset(itemPosition);
            }
            this.MeasureOverride(mSavedPanelSize);
            this.ArrangeOverride(mSavedPanelSize);
            mScrollbar.Value = mCurrentScrollPos;
            mScrollState = SCROLL_STATE.NONE;
        }

        void setScrollValuePreventEvent(double value)
        {
            if (value < mScrollbar.Minimum)
                value = mScrollbar.Minimum;
            if (value > mScrollbar.Maximum)
                value = mScrollbar.Maximum;

            if (mScrollbar != null)
            {
                SCROLL_STATE savedState = mScrollState;
                mScrollState = SCROLL_STATE.SKIP;
                mScrollbar.Value = value;
                mScrollState = savedState;
            }
        }
        void setScrollValue(double value)
        {
            if (value < mScrollbar.Minimum)
                value = mScrollbar.Minimum;
            if (value > mScrollbar.Maximum)
                value = mScrollbar.Maximum;
            mCurrentScrollPos = value;
            if (mScrollbar != null)
            {
                 mScrollbar.Value = value;
            }
        }

        void mScrollbar_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            if (mScrollState == SCROLL_STATE.SKIP)
                return;

            bool restoreState = false;
            
            if (mScrollState == SCROLL_STATE.NONE)
            {
                if (mCurrentScrollPos < (int)e.NewValue)
                    mScrollState = SCROLL_STATE.CURSOR_DOWN;
                else
                    mScrollState = SCROLL_STATE.CURSOR_UP;
                restoreState = true;
            }
            mCurrentScrollPos = (int)e.NewValue;

            this.MeasureOverride(mSavedPanelSize);
            this.ArrangeOverride(mSavedPanelSize);
            if(restoreState)
                mScrollState = SCROLL_STATE.NONE;
        }


        protected override Size ArrangeOverride(Size finalSize)
        {
            Size panelSize = finalSize;
            mSavedPanelSize = finalSize;

            if (mScrollbar != null)
            {
                Size desiredSize = mScrollbar.DesiredSize;
                desiredSize.Height = finalSize.Height;
                panelSize.Width = finalSize.Width - desiredSize.Width;
                mScrollbar.Arrange(new Rect(new Point(panelSize.Width, 0), desiredSize));
            }

            int position;
            double itemOffsetY;
            if (!mScrollHeight.tryGetItemPosition(mCurrentScrollPos, out position, out itemOffsetY))
            {
                position = 0;
                itemOffsetY = 0;
            }
            else
            {
                itemOffsetY *= -1;
            }

            double y = itemOffsetY;
            int num = 0;
            bool complated = false;
            foreach (UIElement element in base.InternalChildren)
            {
                ScrollBar sb = element as ScrollBar;
                if (sb != null)
                {
                    continue;
                }
                if (num < position || complated)
                {
                    element.Arrange(new Rect(new Point(0, element.DesiredSize.Height * -1), element.DesiredSize));
                    num++;
                    continue;
                }
                element.Arrange(new Rect(new Point(0, y), element.DesiredSize));
                y += element.DesiredSize.Height;
                if (y > this.ActualHeight)
                {
                    complated = true;
                }
            }
            if (mScrollbar != null)
            {
                mScrollbar.LargeChange = finalSize.Height;
                mScrollbar.Maximum = mScrollHeight.getTotalHeight() - finalSize.Height;
            }

            return finalSize;
        }


        protected override Size MeasureOverride(Size constraint)
        {
            Size panelSize = constraint;

            if (mScrollbar != null)
            {
                mScrollbar.Measure(constraint);
                Size desiredSize = mScrollbar.DesiredSize;
                panelSize.Width -= desiredSize.Width;
            }

            int position;
            double itemOffsetY;
            if (!mScrollHeight.tryGetItemPosition(mCurrentScrollPos, out position, out itemOffsetY))
            {
                position = 0;
                itemOffsetY = 0;
            }
            else
            {
                itemOffsetY *= -1;
            }

            double y = itemOffsetY;
            int num = 0;
            double chgDelta = 0;
            
            panelSize.Height = double.PositiveInfinity;

            foreach (UIElement element in base.InternalChildren)
            {
                ScrollBar sb = element as ScrollBar;
                if (sb != null)
                {
                    continue;
                }
                if (num < position)
                {
                    num++;
                    continue;
                }
                Grid grid = element as Grid;
                if (grid != null && grid.Children.Count == 0)
                {
                    UIElement child = mAdapter.getElement(num, null);
                    //child.PreviewKeyDown += UIElement_PreviewKeyDown;
                    //child.PreviewKeyUp += UIElement_PreviewKeyUp;
                    grid.Children.Add(child);
                }
                element.Visibility = System.Windows.Visibility.Visible;
                element.Measure(panelSize);
                Size desiredSize = element.DesiredSize;
                double d = mScrollHeight.setHeight(num, desiredSize.Height);
                if (d != 0 && num == position)
                    chgDelta = d;
                num++;
                y += desiredSize.Height;
                if (y > constraint.Height)
                    break;
            }//End Foreach

            if (y < constraint.Height && num > 0)
            {
                double excessiveSpace = constraint.Height - y;
                double panelHeight = constraint.Height;
                do
                {
                    UIElement element = base.InternalChildren[num];
                    Grid grid = element as Grid;
                    if (grid != null && grid.Children.Count == 0)
                    {
                        UIElement child = mAdapter.getElement(num-1, null);
                        //child.PreviewKeyDown += UIElement_PreviewKeyDown;
                        //child.PreviewKeyUp += UIElement_PreviewKeyUp;
                        grid.Children.Add(child);
                        //grid.Children.Add(mAdapter.getElement(num - 1, null));
                    }
                    element.Visibility = System.Windows.Visibility.Visible;
                    element.Measure(panelSize);
                    Size desiredSize = element.DesiredSize;
                    num--;
                    panelHeight -= desiredSize.Height;
                    mScrollHeight.setHeight(num, desiredSize.Height);
                } while (panelHeight > 0 && num > 0);


                double totalHeight = mScrollHeight.getTotalHeight();


                if (mScrollbar != null)
                {
                    mCurrentScrollPos = totalHeight - constraint.Height;
                    setScrollValuePreventEvent(mCurrentScrollPos);
                }
            }
            else
            {
                if (mScrollbar != null)
                {
                    if (mScrollState == SCROLL_STATE.CURSOR_UP)
                    {
                        mCurrentScrollPos += chgDelta;
                        setScrollValuePreventEvent(mCurrentScrollPos);
                    }
                }
            }
             return constraint;
        }
    }
}
