﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Text;

namespace NT2chCtrl.html
{
    class HtmlEscape
    {
        static bool mInit = false;
        public static void init()
        {
            if (mInit)
                return;
            HTMLEscapeTable.init();
            mInit = true;
        }

        public static char parseHTMLDecimalHexEscape(String source, int offset, out int retVal)
        {
            StringBuilder wrk = new StringBuilder(16);
            bool fHEX = false;
            retVal = 0;
            char c;
            //int nVal;
            byte[] bVal = new byte[2];
            bool loop = true;
            for (int j = offset; j < source.Length; j++)
            {
                c = source[j];
                if (';' == c)
                {
                    if (wrk.Length > 0 && ((fHEX && wrk.Length <= 4) || !fHEX && wrk.Length <= 5))
                    {
                        //DebugUtil.log("convert hex escape: 0x" + wrk);
                        //c = (char)Integer.parseInt(wrk, 16);
                        retVal = j + 1;
                        try
                        {
                            int nVal = int.Parse(wrk.ToString(), fHEX ? NumberStyles.HexNumber : NumberStyles.Integer);
                            bVal[0] = (byte)(nVal & 0x000000ff);
                            bVal[1] = (byte)((nVal >> 8) & 0x000000ff);
                            MemoryStream ms = new MemoryStream(bVal, false);
                            //Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                            StreamReader sr = new StreamReader(ms);
                            c = (char)sr.Read();
                            sr.Close();
                            ms.Close();
                            return c;
                        }
                        catch (Exception e)
                        {
                            return '\0';
                        }
                    }
                    break;
                }
                else if ('x' == c || 'X' == c)
                {
                    if (j != offset)
                    {
                        break;
                    }
                    fHEX = true;
                }
                else
                {
                    switch (HtmlParser.getCharToken(c))
                    {
                        case HtmlParser.CHAR_TOKEN.NUMBER:
                            wrk.Append(c);// = wrk + c;
                            break;
                        case HtmlParser.CHAR_TOKEN.ALPHA:
                            if (!fHEX)
                            {
                                loop = false;
                                break;
                            }
                            wrk.Append(c);// = wrk + c;
                            break;
                        default:
                            loop = false;
                            break;
                    }
                    if (!loop)
                        break;
                }
            }// End of the for
            return '\0';
        }


        class HttpEscapeTree
        {
            public char mC;
            public char mCode;
            public List<HttpEscapeTree> mTree = new List<HttpEscapeTree>();
            public HttpEscapeTree(char c) { mC = c; mCode = '\0'; }
        }



        public class HTMLEscapeTable
        {
            static HttpEscapeTree mTopTree = null;
            //private static ArrayList<HTMLEscape> mHtmlEscape = new ArrayList<HTMLEscape>();
            private String mEscape;
            private char mCode;
            //private ArrayList<HTMLEscapeTable> mTree = new ArrayList<HTMLEscapeTable>();

            HTMLEscapeTable(String escape, char code)
            {
                mEscape = escape;
                mCode = code;
            }

            //static int counter = 0;

            public static char getCodeFromEscape(String escape, int index, out int returnLength)
            {
                return findTree(mTopTree, escape, index, out returnLength);
            }

            static char findTree(HttpEscapeTree parent, String escape, int index, out int returnLength)
            {

                if (escape.Length == index)
                {
                    returnLength = -1;
                    return '\0';
                }

                char c = escape[index];

                for (int i = 0; i < parent.mTree.Count; i++)
                {
                    HttpEscapeTree current = parent.mTree[i];
                    if (current.mC == c)
                    {
                        index++;
                        if (';' == c)
                        {
                            returnLength = index;
                            return current.mCode;
                        }
                        return findTree(current, escape, index, out returnLength);
                    }
                }
                returnLength = -1;
                return '\0';// No match code available
            }


            public static void init()
            {
                //Making escape-code tree
                mTopTree = new HttpEscapeTree((char)0x00);
                //DebugUtil.log("HTMLEscape.length: " + htmlEscape.length);
                for (int i = 0; i < htmlEscape.Length; i++)
                {
                    parseTree(mTopTree, htmlEscape[i].mEscape, 0, htmlEscape[i].mCode);
                }
            }


            static void parseTree(HttpEscapeTree tree, String source, int index, char code)
            {
                try
                {
                    List<HttpEscapeTree> parentTree = tree.mTree;
                    HttpEscapeTree newTree;
                    char c = source[index];
                    int i;
                    for (i = 0; i < parentTree.Count; i++)
                    {
                        if (parentTree[i].mC == c)
                        {
                            break;
                        }
                    }
                    if (i == parentTree.Count)
                    {
                        newTree = new HttpEscapeTree(c);
                        parentTree.Add(newTree);
                        //    NTDebug.l("HTMLEscape.parseTree(): err occured. #1");
                        //    return;
                        //}
                    }
                    else
                    {
                        newTree = parentTree[i];//.get(i);
                    }
                    index++;
                    if (source.Length == index)
                    {
                        newTree.mCode = code;
                        //DebugUtil.log("EscapeCode setup:" + source + ":" + String.format("0x%04X", (int)code) + ":" + ++counter);
                        //DebugUtil.log("EscapeCode setup:" + source + ":" + String.format("0x%04X", 10));
                    }
                    else
                    {
                        parseTree(newTree, source, index, code);
                    }
                }
                catch (Exception e)
                {
                    //NTDebug.l(e.Message);
                }
            }

            static HTMLEscapeTable[] htmlEscape = {
		        new HTMLEscapeTable("quot;", (char)0x22),//quotation mark = APL quote
		        new HTMLEscapeTable("amp;", (char)0x26),//ampersand
		        new HTMLEscapeTable("lt;", (char)0x3C),//less-than sign
		        new HTMLEscapeTable("gt;", (char)0x3E),//greater-than sign
		        new HTMLEscapeTable("nbsp;", (char)0xA0),//no-break space = non-breaking space
		        new HTMLEscapeTable("iexcl;", (char)0xA1),//inverted exclamation mark
		        new HTMLEscapeTable("cent;", (char)0xA2),//cent sign
		        new HTMLEscapeTable("pound;", (char)0xA3),//pound sign
		        new HTMLEscapeTable("curren;", (char)0xA4),//currency sign
		        new HTMLEscapeTable("yen;", (char)0xA5),//yen sign = yuan sign
		        new HTMLEscapeTable("brvbar;", (char)0xA6),//broken bar = broken vertical bar
		        new HTMLEscapeTable("sect;", (char)0xA7),//section sign
		        new HTMLEscapeTable("uml;", (char)0xA8),//diaeresis = spacing diaeresis
		        new HTMLEscapeTable("copy;", (char)0xA9),//copyright sign
		        new HTMLEscapeTable("ordf;", (char)0xAA),//feminine ordinal indicator
		        new HTMLEscapeTable("laquo;", (char)0xAB),//left-pointing double angle quotation mark = left pointing guillemet
		        new HTMLEscapeTable("not;", (char)0xAC),//not sign
		        new HTMLEscapeTable("shy;", (char)0xAD),//soft hyphen = discretionary hyphen
		        new HTMLEscapeTable("reg;", (char)0xAE),//registered sign = registered trade mark sign
		        new HTMLEscapeTable("macr;", (char)0xAF),//macron = spacing macron = overline = APL overbar
		        new HTMLEscapeTable("deg;", (char)0xB0),//degree sign
		        new HTMLEscapeTable("plusmn;", (char)0xB1),//plus-minus sign = plus-or-minus sign
		        new HTMLEscapeTable("sup2;", (char)0xB2),//superscript two = superscript digit two = squared
		        new HTMLEscapeTable("sup3;", (char)0xB3),//superscript three = superscript digit three = cubed
		        new HTMLEscapeTable("acute;",(char)0xB4),//acute accent = spacing acute
		        new HTMLEscapeTable("micro;",(char) 0xB5),//micro sign
		        new HTMLEscapeTable("para;", (char)0xB6),//pilcrow sign = paragraph sign
		        new HTMLEscapeTable("middot;", (char)0xB7),//middle dot = Georgian comma = Greek middle dot
		        new HTMLEscapeTable("cedil;", (char)0xB8),//cedilla = spacing cedilla
		        new HTMLEscapeTable("sup1;", (char)0xB9),//superscript one = superscript digit one
		        new HTMLEscapeTable("ordm;", (char)0xBA),//masculine ordinal indicator
		        new HTMLEscapeTable("raquo;", (char)0xBB),//right-pointing double angle quotation mark = right pointing guillemet
		        new HTMLEscapeTable("frac14;", (char)0xBC),//vulgar fraction one quarter = fraction one quarter
		        new HTMLEscapeTable("frac12;", (char)0xBD),//vulgar fraction one half = fraction one half
		        new HTMLEscapeTable("frac34;", (char)0xBE),//vulgar fraction three quarters = fraction three quarters
		        new HTMLEscapeTable("iquest;", (char)0xBF),//inverted question mark = turned question mark
		        new HTMLEscapeTable("Agrave;", (char)0xC0),//latin capital letter A with grave = latin capital letter A grave
		        new HTMLEscapeTable("Aacute;", (char)0xC1),//latin capital letter A with acute
		        new HTMLEscapeTable("Acirc;", (char)0xC2),//latin capital letter A with circumflex
		        new HTMLEscapeTable("Atilde;", (char)0xC3),//latin capital letter A with tilde
		        new HTMLEscapeTable("Auml;", (char)0xC4),//latin capital letter A with diaeresis
		        new HTMLEscapeTable("Aring;", (char)0xC5),//latin capital letter A with ring above = latin capital letter A ring
		        new HTMLEscapeTable("AElig;", (char)0xC6),//latin capital letter AE = latin capital ligature AE
		        new HTMLEscapeTable("Ccedil;", (char)0xC7),//latin capital letter C with cedilla
		        new HTMLEscapeTable("Egrave;", (char)0xC8),//latin capital letter E with grave
		        new HTMLEscapeTable("Eacute;", (char)0xC9),//latin capital letter E with acute
		        new HTMLEscapeTable("Ecirc;", (char)0xCA),//latin capital letter E with circumflex
		        new HTMLEscapeTable("Euml;",(char) 0xCB),//latin capital letter E with diaeresis
		        new HTMLEscapeTable("Igrave;", (char)0xCC),//latin capital letter I with grave
		        new HTMLEscapeTable("Iacute;", (char)0xCD),//latin capital letter I with acute
		        new HTMLEscapeTable("Icirc;", (char)0xCE),//latin capital letter I with circumflex
		        new HTMLEscapeTable("Iuml;",(char) 0xCF),//latin capital letter I with diaeresis
		        new HTMLEscapeTable("ETH;", (char)0xD0),//latin capital letter ETH
		        new HTMLEscapeTable("Ntilde;", (char)0xD1),//latin capital letter N with tilde
		        new HTMLEscapeTable("Ograve;", (char)0xD2),//latin capital letter O with grave
		        new HTMLEscapeTable("Oacute;",(char) 0xD3),//latin capital letter O with acute
		        new HTMLEscapeTable("Ocirc;", (char)0xD4),//latin capital letter O with circumflex
		        new HTMLEscapeTable("Otilde;", (char)0xD5),//latin capital letter O with tilde
		        new HTMLEscapeTable("Ouml;", (char)0xD6),//latin capital letter O with diaeresis
		        new HTMLEscapeTable("times;", (char)0xD7),//multiplication sign
		        new HTMLEscapeTable("Oslash;", (char)0xD8),//latin capital letter O with stroke = latin capital letter O slash
		        new HTMLEscapeTable("Ugrave;", (char)0xD90),//latin capital letter U with grave
		        new HTMLEscapeTable("Uacute;", (char)0xDA),//latin capital letter U with acute
		        new HTMLEscapeTable("Ucirc;", (char)0xDB),//latin capital letter U with circumflex
		        new HTMLEscapeTable("Uuml;", (char)0xDC),//latin capital letter U with diaeresis
		        new HTMLEscapeTable("Yacute", (char)0xDD),//latin capital letter Y with acute
		        new HTMLEscapeTable("THORN;", (char)0xDE),//latin capital letter THORN
		        new HTMLEscapeTable("szlig;", (char)0xDF),//latin small letter sharp s = ess-zed
		        new HTMLEscapeTable("agrave;", (char)0xE0),//latin small letter a with grave = latin small letter a grave
		        new HTMLEscapeTable("aacute;", (char)0xE1),//latin small letter a with acute
		        new HTMLEscapeTable("acirc;", (char)0xE2),//latin small letter a with circumflex
		        new HTMLEscapeTable("atilde;", (char)0xE3),//latin small letter a with tilde
		        new HTMLEscapeTable("auml;", (char)0xE4),//latin small letter a with diaeresis
		        new HTMLEscapeTable("aring;", (char)0xE5),//latin small letter a with ring above = latin small letter a ring
		        new HTMLEscapeTable("aelig;", (char)0xE6),//latin small letter ae = latin small ligature ae
		        new HTMLEscapeTable("ccedil;", (char)0xE7),//latin small letter c with cedilla
		        new HTMLEscapeTable("egrave;", (char)0xE8),//latin small letter e with grave
		        new HTMLEscapeTable("eacute;", (char)0xE9),//latin small letter e with acute
		        new HTMLEscapeTable("ecirc;", (char)0xEA),//latin small letter e with circumflex
		        new HTMLEscapeTable("euml;", (char)0xEB),//latin small letter e with diaeresis
		        new HTMLEscapeTable("igrave;", (char)0xEC),//latin small letter i with grave
		        new HTMLEscapeTable("iacute;", (char)0xED),//latin small letter i with acute
		        new HTMLEscapeTable("icirc;", (char)0xEE),//latin small letter i with circumflex
		        new HTMLEscapeTable("iuml;", (char)0xEF),//latin small letter i with diaeresis
		        new HTMLEscapeTable("eth;", (char)0xF0),//latin small letter eth
		        new HTMLEscapeTable("ntilde;", (char)0xF1),//latin small letter n with tilde
		        new HTMLEscapeTable("ograve;", (char)0xF2),//latin small letter o with grave
		        new HTMLEscapeTable("oacute;", (char)0xF3),//latin small letter o with acute
		        new HTMLEscapeTable("ocirc;",(char) 0xF4),//latin small letter o with circumflex
		        new HTMLEscapeTable("otilde;", (char)0xF5),//latin small letter o with tilde
		        new HTMLEscapeTable("ouml;", (char)0xF6),//latin small letter o with diaeresis
		        new HTMLEscapeTable("divide;", (char)0xF7),//division sign
		        new HTMLEscapeTable("oslash;", (char)0xF8),//latin small letter o with stroke, = latin small letter o slash
		        new HTMLEscapeTable("ugrave;", (char)0xF9),//latin small letter u with grave
		        new HTMLEscapeTable("uacute;", (char)0xFA),//latin small letter u with acute
		        new HTMLEscapeTable("ucirc;", (char)0xFB),//latin small letter u with circumflex
		        new HTMLEscapeTable("uuml;", (char)0xFC),//latin small letter u with diaeresis
		        new HTMLEscapeTable("yacute;", (char)0xFD),//latin small letter y with acute
		        new HTMLEscapeTable("thorn;",(char) 0xFE),//latin small letter thorn with
		        new HTMLEscapeTable("yuml;", (char)0xFF),//latin small letter y with diaeresis
	
	
		        new HTMLEscapeTable("OElig;", (char)0x0152),//latin capital ligature OE
		        new HTMLEscapeTable("oelig;", (char)0x0153),//latin small ligature oe
		        new HTMLEscapeTable("Scaron;", (char)0x0160),//latin capital letter S with caron
		        new HTMLEscapeTable("scaron;", (char)0x0161),//latin small letter s with caron
		        new HTMLEscapeTable("Yuml;", (char)0x0178),//latin capital letter Y with diaeresis
		        new HTMLEscapeTable("fnof;", (char)0x0192),//latin small f with hook = function = florin
		        new HTMLEscapeTable("circ;", (char)0x02C6),//modifier letter circumflex accent
		        new HTMLEscapeTable("tilde;", (char)0x02DC),//small tilde
		        new HTMLEscapeTable("Alpha;", (char)0x391),//greek capital letter alpha
		        new HTMLEscapeTable("Beta;", (char)0x392),//greek capital letter beta
		        new HTMLEscapeTable("Gamma;", (char)0x393),//greek capital letter gamma
		        new HTMLEscapeTable("Delta;", (char)0x394),//greek capital letter delta
		        new HTMLEscapeTable("Epsilon;", (char)0x395),//greek capital letter epsilon
		        new HTMLEscapeTable("Zeta;", (char)0x396),//greek capital letter zeta
		        new HTMLEscapeTable("Eta;", (char)0x397),//greek capital letter eta
		        new HTMLEscapeTable("Theta;", (char)0x398),//greek capital letter theta
		        new HTMLEscapeTable("Iota;", (char)0x399),//greek capital letter iota
		        new HTMLEscapeTable("Kappa;", (char)0x39A),//greek capital letter kappa
		        new HTMLEscapeTable("Lambda;", (char)0x39B),//greek capital letter lambda
		        new HTMLEscapeTable("Mu;", (char)0x39C),//greek capital letter mu
		        new HTMLEscapeTable("Nu;", (char)0x39D),//greek capital letter nu
		        new HTMLEscapeTable("Xi;", (char)0x39E),//greek capital letter xi
		        new HTMLEscapeTable("Omicron;", (char)0x39F),//greek capital letter omicron
		        new HTMLEscapeTable("Pi;", (char)0x3A0),//greek capital letter pi
		        new HTMLEscapeTable("Rho;", (char)0x3A1),//greek capital letter rho
		        new HTMLEscapeTable("Sigma;", (char)0x3A3),//greek capital letter sigma
		        new HTMLEscapeTable("Tau;", (char)0x3A4),//greek capital letter tau
		        new HTMLEscapeTable("Upsilon;", (char)0x3A5),//greek capital letter upsilon
		        new HTMLEscapeTable("Phi;", (char)0x3A6),//greek capital letter phi
		        new HTMLEscapeTable("Chi;", (char)0x3A7),//greek capital letter chi
		        new HTMLEscapeTable("Psi;", (char)0x3A8),//greek capital letter psi
		        new HTMLEscapeTable("Omega;", (char)0x3A9),//greek capital letter omega
		        new HTMLEscapeTable("alpha;", (char)0x3B1),//greek small letter alpha
		        new HTMLEscapeTable("beta;", (char)0x3B2),//greek small letter beta
		        new HTMLEscapeTable("gamma;", (char)0x3B3),//greek small letter gamma
		        new HTMLEscapeTable("delta;", (char)0x3B4),//greek small letter delta
		        new HTMLEscapeTable("epsilon;", (char)0x3B5),//greek small letter epsilon
		        new HTMLEscapeTable("zeta;", (char)0x3B6),//greek small letter zeta
		        new HTMLEscapeTable("eta;", (char)0x3B7),//greek small letter eta
		        new HTMLEscapeTable("theta;", (char)0x3B8),//greek small letter theta
		        new HTMLEscapeTable("iota;", (char)0x3B9),//greek small letter iota
		        new HTMLEscapeTable("kappa;", (char)0x3BA),//greek small letter kappa
		        new HTMLEscapeTable("lambda;", (char)0x3BB),//greek small letter lambda
		        new HTMLEscapeTable("mu;", (char)0x3BC),//greek small letter mu
		        new HTMLEscapeTable("nu;", (char)0x3BD),//greek small letter nu
		        new HTMLEscapeTable("xi;", (char)0x3BE),//greek small letter xi
		        new HTMLEscapeTable("omicron;", (char)0x3BF),//greek small letter omicron
		        new HTMLEscapeTable("pi;", (char)0x3C0),//greek small letter pi
		        new HTMLEscapeTable("rho;", (char)0x3C1),//greek small letter rho
		        new HTMLEscapeTable("sigmaf;", (char)0x3C2),//greek small letter final sigma
		        new HTMLEscapeTable("sigma;", (char)0x3C3),//greek small letter sigma
		        new HTMLEscapeTable("tau;", (char)0x3C4),//greek small letter tau
		        new HTMLEscapeTable("upsilon;", (char)0x3C5),//greek small letter upsilon
		        new HTMLEscapeTable("phi;", (char)0x3C6),//greek small letter phi
		        new HTMLEscapeTable("chi;", (char)0x3C7),//greek small letter chi
		        new HTMLEscapeTable("psi;", (char)0x3C8),//greek small letter psi
		        new HTMLEscapeTable("omega;", (char)0x3C9),//greek small letter omega
		        new HTMLEscapeTable("thetasym;", (char)0x3D1),//greek small letter theta symbol
		        new HTMLEscapeTable("upsih;", (char)0x3D2),//greek upsilon with hook symbol
		        new HTMLEscapeTable("piv;", (char)0x3D3),//greek pi symbol
		        new HTMLEscapeTable("bull;", (char)0x2022),//bullet = black small circle
		        new HTMLEscapeTable("hellip;", (char)0x2026),//horizontal ellipsis = three dot leader
		        new HTMLEscapeTable("prime;", (char)0x2032),//prime = minutes = feet
		        new HTMLEscapeTable("Prime;", (char)0x2033),//double prime = seconds = inches
		        new HTMLEscapeTable("oline;", (char)0x203E),//overline = spacing overscore
		        new HTMLEscapeTable("frasl;", (char)0x2044),//fraction slash
		        new HTMLEscapeTable("weierp;", (char)0x2118),//script capital P = power set = Weierstrass p
		        new HTMLEscapeTable("image;", (char)0x2111),//blackletter capital I = imaginary part
		        new HTMLEscapeTable("real;", (char)0x211C),//blackletter capital R = real part symbol
		        new HTMLEscapeTable("trade;", (char)0x2122),//trade mark sign
		        new HTMLEscapeTable("alefsym;", (char)0x2135),//alef symbol = first transfinite cardinal
		        new HTMLEscapeTable("larr;", (char)0x2190),//leftwards arrow
		        new HTMLEscapeTable("uarr;", (char)0x2191),//upwards arrow
		        new HTMLEscapeTable("rarr;", (char)0x2192),//rightwards arrow
		        new HTMLEscapeTable("darr;", (char)0x2193),//downwards arrow
		        new HTMLEscapeTable("harr;", (char)0x2194),//left right arrow
		        new HTMLEscapeTable("crarr;", (char)0x21B5),//downwards arrow with corner leftwards = carriage return
		        new HTMLEscapeTable("lArr;", (char)0x21D0),//leftwards double arrow
		        new HTMLEscapeTable("uArr;", (char)0x21D1),//upwards double arrow
		        new HTMLEscapeTable("rArr;", (char)0x21D2),//rightwards double arrow
		        new HTMLEscapeTable("dArr;", (char)0x21D3),//downwards double arrow
		        new HTMLEscapeTable("hArr;", (char)0x21D4),//left right double arrow
		        new HTMLEscapeTable("forall;", (char)0x2200),//for all
		        new HTMLEscapeTable("part;", (char)0x2202),//partial differential
		        new HTMLEscapeTable("exist;", (char)0x2203),//there exists
		        new HTMLEscapeTable("empty;", (char)0x2205),//empty set = null set = diameter
		        new HTMLEscapeTable("nabla;", (char)0x2207),//nabla = backward difference
		        new HTMLEscapeTable("isin;", (char)0x2208),//element of
		        new HTMLEscapeTable("notin;", (char)0x2209),//not an element of
		        new HTMLEscapeTable("ni;", (char)0x220B),//contains as member
		        new HTMLEscapeTable("prod;", (char)0x220F),//n-ary product = product sign
		        new HTMLEscapeTable("sum;", (char)0x2211),//n-ary sumation
		        new HTMLEscapeTable("minus;", (char)0x2212),//minus sign
		        new HTMLEscapeTable("lowast;", (char)0x2217),//asterisk operator
		        new HTMLEscapeTable("radic;", (char)0x221A),//square root = radical sign
		        new HTMLEscapeTable("prop;", (char)0x221D),//proportional to
		        new HTMLEscapeTable("infin;", (char)0x221E),//infinity
		        new HTMLEscapeTable("ang;", (char)0x2220),//angle
		        new HTMLEscapeTable("and;", (char)0x2227),//logical and = wedge
		        new HTMLEscapeTable("or;", (char)0x2228),//logical or = vee
		        new HTMLEscapeTable("cap;", (char)0x2229),//intersection = cap
		        new HTMLEscapeTable("cup;", (char)0x222A),//union = cup
		        new HTMLEscapeTable("int;", (char)0x222B),//integral
		        new HTMLEscapeTable("there4;", (char)0x2234),//therefore
		        new HTMLEscapeTable("sim;", (char)0x223C),//tilde operator = varies with = similar to
		        new HTMLEscapeTable("cong;", (char)0x2245),//approximately equal to
		        new HTMLEscapeTable("asymp;", (char)0x2248),//almost equal to = asymptotic to
		        new HTMLEscapeTable("ne;", (char)0x2260),//not equal to
		        new HTMLEscapeTable("equiv;", (char)0x2261),//identical to
		        new HTMLEscapeTable("le;", (char)0x2264),//less-than or equal to
		        new HTMLEscapeTable("ge;", (char)0x2265),//greater-than or equal to
		        new HTMLEscapeTable("sub;", (char)0x2282),//subset of
		        new HTMLEscapeTable("sup;", (char)0x2283),//superset of
		        new HTMLEscapeTable("nsub;", (char)0x2284),//not a subset of
		        new HTMLEscapeTable("sube;", (char)0x2286),//subset of or equal to
		        new HTMLEscapeTable("supe;", (char)0x2287),//superset of or equal to
		        new HTMLEscapeTable("oplus;", (char)0x2295),//circled plus = direct sum
		        new HTMLEscapeTable("otimes;", (char)0x2297),//circled times = vector product
		        new HTMLEscapeTable("perp;", (char)0x22A5),//up tack = orthogonal to = perpendicular
		        new HTMLEscapeTable("sdot;", (char)0x22C5),//dot operator
		        new HTMLEscapeTable("lceil;", (char)0x2308),//left ceiling = apl upstile
		        new HTMLEscapeTable("rceil;", (char)0x2309),//right ceiling
		        new HTMLEscapeTable("lfloor;", (char)0x230A),//left floor = apl downstile
		        new HTMLEscapeTable("rfloor;", (char)0x230B),//right floor
		        new HTMLEscapeTable("lang;", (char)0x2329),//left-pointing angle bracket = bra
		        new HTMLEscapeTable("rang;", (char)0x232A),//right-pointing angle bracket = ket
		        new HTMLEscapeTable("loz;", (char)0x25CA),//lozenge
		        new HTMLEscapeTable("spades;", (char)0x2660),//black spade suit
		        new HTMLEscapeTable("clubs;", (char)0x2663),//black club suit = shamrock
		        new HTMLEscapeTable("hearts;", (char)0x2665),//black heart suit = valentine
		        new HTMLEscapeTable("diams;", (char)0x2666),//black diamond suit
		        new HTMLEscapeTable("ensp;", (char)0x2002),//en space
		        new HTMLEscapeTable("emsp;", (char)0x2003),//em space
		        new HTMLEscapeTable("thinsp;", (char)0x2009),//thin space
		        new HTMLEscapeTable("zwnj;", (char)0x200C),//zero width non-joiner
		        new HTMLEscapeTable("zwj;", (char)0x200D),//zero width joiner
		        new HTMLEscapeTable("lrm;", (char)0x200E),//left-to-right mark
		        new HTMLEscapeTable("rlm;", (char)0x200F),//right-to-left mark
		        new HTMLEscapeTable("ndash;", (char)0x2013),//en dash
		        new HTMLEscapeTable("mdash;", (char)0x2014),//em dash
		        new HTMLEscapeTable("lsquo;", (char)0x2018),//left single quotation mark
		        new HTMLEscapeTable("rsquo;", (char)0x2019),//right single quotation mark
		        new HTMLEscapeTable("sbquo;", (char)0x201A),//single low-9 quotation mark
		        new HTMLEscapeTable("ldquo;", (char)0x201C),//left double quotation mark
		        new HTMLEscapeTable("rdquo;", (char)0x201D),//right double quotation mark
		        new HTMLEscapeTable("bdquo;", (char)0x201E),//double low-9 quotation mark
		        new HTMLEscapeTable("dagger;", (char)0x2020),//dagger
		        new HTMLEscapeTable("Dagger;", (char)0x2021),//double dagger
		        new HTMLEscapeTable("permil;", (char)0x2030),//per mille sign
		        new HTMLEscapeTable("lsaquo;", (char)0x2039),//single left-pointing angle quotation mark
	        };
        }// end of class HTMLEscape
    }
}
