﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html
{
    partial class HtmlParser
    {
        public enum CHAR_TOKEN
        {
            LT, GT, NL, NUMBER, ALPHA,
            SQUOTE, DQUOTE, WHITESPACE,
            EXCLAMATION, HYPHIEN,PLUS,SLASH,
            ESCAPE, AMP, COLON, SEMICOLON, EQUAL,
            SHARP, ASTOR, UNDERBAR,
            COMMA, PERIOD,DOLLAR,
            L_CURLY_BRACKET, R_CURLY_BRACKET,
            L_BRACKET, R_BRACKET,PERCENT,
            L_SQUARE_BRACKET, R_SQUARE_BRACKET,
            OTHER, ERROR 
        }


        public static CHAR_TOKEN getCharToken(char c)
        {
            switch (c)
            {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                    return CHAR_TOKEN.NUMBER;
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                    return CHAR_TOKEN.ALPHA;
                case '\t':
                case '\r':
                case ' ':
                    return CHAR_TOKEN.WHITESPACE;
                case '\n':
                    return CHAR_TOKEN.NL;
                case '<':
                    return CHAR_TOKEN.LT;
                case '>':
                    return CHAR_TOKEN.GT;
                case '"':
                    return CHAR_TOKEN.DQUOTE;
                case '\'':
                    return CHAR_TOKEN.SQUOTE;
                case '!':
                    return CHAR_TOKEN.EXCLAMATION;
                case '-':
                    return CHAR_TOKEN.HYPHIEN;
                case '+':
                    return CHAR_TOKEN.PLUS;
                case '\\':
                    return CHAR_TOKEN.ESCAPE;
                case '/':
                    return CHAR_TOKEN.SLASH;
                case '&':
                    return CHAR_TOKEN.AMP;
                case ':':
                    return CHAR_TOKEN.COLON;
                case ';':
                    return CHAR_TOKEN.SEMICOLON;
                case '=':
                    return CHAR_TOKEN.EQUAL;
                case '_':
                    return CHAR_TOKEN.UNDERBAR;
                case '*':
                    return CHAR_TOKEN.ASTOR;
                case '#':
                    return CHAR_TOKEN.SHARP;
                case '.':
                    return CHAR_TOKEN.PERIOD;
                case ',':
                    return CHAR_TOKEN.COMMA;
                case '(':
                    return CHAR_TOKEN.L_BRACKET;
                case ')':
                    return CHAR_TOKEN.R_BRACKET;
                case '[':
                    return CHAR_TOKEN.L_SQUARE_BRACKET;
                case ']':
                    return CHAR_TOKEN.R_SQUARE_BRACKET;
                case '{':
                    return CHAR_TOKEN.L_CURLY_BRACKET;
                case '}':
                    return CHAR_TOKEN.R_CURLY_BRACKET;
                case '%':
                    return CHAR_TOKEN.PERCENT;    
                case '$':
                    return CHAR_TOKEN.DOLLAR;
                default:
                    return CHAR_TOKEN.OTHER;
            }           
        }


    }
}
