﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NT2chCtrl.html.js
{
    enum LOOP_EXIT_TYPE
    {
        BREAK, CONTINUE,NONE
    }

    partial class JsRootFunction : JsFunction
    {
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            LOOP_EXIT_TYPE exitType;
            int nVal;

            //DebugContext dCtx = ctx.getDbgCtx();
            JsVariant result = null;
            if (ctx == null)
                ctx = new JsFunctionContext();

            int iCount = mInstructions.Count;
            for (int i = 0; i < iCount; i++)
            {
                List<JsVariant> list = mInstructions[i];

                int count = list.Count;
                for (int j = 0; j < count; j++)
                {
                    JsVariant var = list[j];

                    JsIdentifier idVal = var as JsIdentifier;
                    if (idVal != null)
                    {
                        ctx.setValue(idVal, new JsUndefValue());
                        continue;
                    }
                    JsFunction func = var as JsFunction;
                    if (func == null)
                        continue;
                    //JsOpFunction_else funcelse = func as JsOpFunction_else;


                    JsOpFunction_if funcIf = func as JsOpFunction_if;
                    JsOpFunction_for funcFor = func as JsOpFunction_for;
                    if (funcIf != null)
                    {
                        result = Execute_if(ctx, rootElement, mInstructions, i, j, out nVal, out exitType);
                        if (result == null || exitType != LOOP_EXIT_TYPE.NONE)
                            goto LOOP_END;
                        i = nVal;
                        break;
                    }
                    else if (funcFor != null)
                    {
                        result = Execute_for(ctx, rootElement, mInstructions, i, j, out nVal);
                        if (result == null)
                            goto LOOP_END;
                        i = nVal;
                        break;
                    }
                    else
                    {
                        result = func.Execute(ctx, rootElement);
                    }
                    if (result == null)
                    {
                        goto LOOP_END;
                    }
                }
            }
        LOOP_END:
            return result;
        }

        private JsVariant Execute_if(JsFunctionContext ctx, HtmlElement rootElement,
            List<List<JsVariant>> instructions, int curIdx, int j, out int endIdx, out  LOOP_EXIT_TYPE exitType)
        {
            exitType = LOOP_EXIT_TYPE.NONE;
            // int trueCount = 0;
            bool firstTrue = false;
            bool TrueFinish = false;
            DebugContext dCtx = ctx.getDbgCtx();
            //bool bExec = false;
            JsOpFunction_else funcelse;
            endIdx = 0;
            JsOpFunction_if funcIf = instructions[curIdx][j] as JsOpFunction_if;
            if (funcIf == null)
                return null;
            funcIf.setDebugContext(dCtx);
            JsBooleanValue bVal = funcIf.Execute(ctx, rootElement) as JsBooleanValue;
            if (bVal == null)
                return null;
            if (bVal.getValue())
                firstTrue = true;

            bool finalElse = false;

            int length = instructions.Count;
            int state = 0;
            for (int i = curIdx + 1; i < length; i++)
            {
                List<JsVariant> val1 = instructions[i];
                if (val1.Count == 0)
                    continue;

                JsVariant val = val1[0];

                if (state == 2)
                {
                    if (finalElse)
                        return null;
                    funcelse = val as JsOpFunction_else;
                    if (funcelse == null)
                    {
                        return JsUndefValue.getConstant();
                    }
                    funcelse.setDebugContext(dCtx);
                    state = 3;
                    /*if (firstTrue)
                    {
                        TrueFinish = true;
                    }
                    else
                    {
                        firstTrue = true;
                    }*/
                    continue;
                }

                if (val is JsOpFunction_if)
                {
                    if (firstTrue)
                    {
                        TrueFinish = true;
                    }
                    switch (state)
                    {
                        case 0:
                            if (null == Execute_if(ctx, rootElement,
                                instructions, i, 0, out endIdx, out exitType))
                                return null;
                            if (exitType != LOOP_EXIT_TYPE.NONE)
                            {
                                TrueFinish = true;
                            }
                            i = endIdx;
                            state = 2;
                            break;
                        case 1:
                            if (null == Execute_if(ctx, rootElement,
                                instructions, i, 0, out endIdx, out exitType))
                                return null;
                            if (exitType != LOOP_EXIT_TYPE.NONE)
                            {
                                TrueFinish = true;
                            }
                            i = endIdx;
                            break;
                        case 2:
                            return null;
                        case 3:
                            funcIf = val as JsOpFunction_if;
                            if (funcIf == null)
                                return null;
                            funcIf.setDebugContext(dCtx);
                            if (!TrueFinish)
                            {
                                bVal = funcIf.Execute(ctx, rootElement) as JsBooleanValue;
                                if (bVal.getValue())
                                    firstTrue = true;
                            }
                            state = 0;
                            break;
                    }
                }
                else if (val is JsOpFunction_for)
                {
                    switch (state)
                    {
                        case 0:
                            if (null == Execute_for(ctx, rootElement,
                                instructions, i, 0, out endIdx))
                                return null;
                            i = endIdx;
                            state = 2;
                            break;
                        case 1:
                            if (null == Execute_for(ctx, rootElement,
                                instructions, i, 0, out endIdx))
                                return null;
                            i = endIdx;
                            break;
                        default:
                            return null;
                    }
                }
                else if (val is JsLoopBreak)
                {
                    if (state == 0)
                    {
                        if (firstTrue && !TrueFinish)
                        {
                            exitType = LOOP_EXIT_TYPE.BREAK;
                            TrueFinish = true;
                        }
                        state = 2;
                        endIdx = i;
                    }
                    else if (state == 1)
                    {
                        if (firstTrue && !TrueFinish)
                        {
                            exitType = LOOP_EXIT_TYPE.BREAK;
                            TrueFinish = true;
                        }
                    }
                    else if (state == 3)
                    {
                        if (/*firstTrue &&*/ !TrueFinish)
                        {
                            exitType = LOOP_EXIT_TYPE.BREAK;
                        }
                        endIdx = i;
                        return JsUndefValue.getConstant();
                    }
                    else
                    {
                        return null;
                    }
                }
                else if (val is JsLoopContinue)
                {
                    if (state == 0)
                    {
                        if (firstTrue && !TrueFinish)
                        {
                            exitType = LOOP_EXIT_TYPE.CONTINUE;
                            TrueFinish = true;
                        }
                        state = 2;
                        endIdx = i;
                    }
                    else if (state == 1)
                    {
                        if (firstTrue && !TrueFinish)
                        {
                            exitType = LOOP_EXIT_TYPE.CONTINUE;
                            TrueFinish = true;
                        }
                    }
                    else if (state == 3)
                    {
                        if (/*firstTrue &&*/ !TrueFinish)
                        {
                            exitType = LOOP_EXIT_TYPE.CONTINUE;
                        }
                        endIdx = i;
                        return JsUndefValue.getConstant();
                    }
                    else
                    {
                        return null;
                    }
                }
                else if (val is JsL_CURLY_Bracket)
                {
                    ((JsL_CURLY_Bracket)val).setDebugContext(dCtx);
                    if (state != 0 && state != 3)
                        return null;
                    if (state == 3)
                        finalElse = true;
                    state = 1;
                }
                else if (val is JsR_CURLY_Bracket)
                {
                    ((JsR_CURLY_Bracket)val).setDebugContext(dCtx);
                    if (state == 0 && state == 3)
                        return null;
                    endIdx = i;
                    if (finalElse)
                        return JsUndefValue.getConstant();
                    state = 2;
                }
                else if (val is JsFunction)
                {
                    JsFunction func = (JsFunction)val;
                    switch (state)
                    {
                        case 0://if () single line
                            endIdx = i;
                            if (firstTrue && !TrueFinish)
                            {
                                func.Execute(ctx, rootElement);
                            }
                            state = 2;
                            break;
                        //else
                        //    return JsUndefValue.getConstant();
                        case 1://if(){ multi lines}
                            if (finalElse)
                            {
                                if (!firstTrue && !TrueFinish)
                                {
                                    if (null == func.Execute(ctx, rootElement))
                                        return null;
                                }
                            }
                            else if (firstTrue && !TrueFinish)
                            {
                                if (null == func.Execute(ctx, rootElement))
                                    return null;
                            }
                            break;
                        case 2://just after right curly bracket
                            return JsUndefValue.getConstant();
                        case 3:// just after else
                            if (!firstTrue && !TrueFinish)
                            {
                                if (null == func.Execute(ctx, rootElement))
                                    return null;
                            }
                            endIdx = i;
                            return JsUndefValue.getConstant();
                        default:
                            return null;

                    }
                }
                else
                {
                    return null;
                }
            }
            endIdx = length;
            return JsUndefValue.getConstant();
        }

        private JsVariant Execute_for(JsFunctionContext ctx, HtmlElement rootElement,
            List<List<JsVariant>> instructions, int curIdx, int j, out int endIdx)
        {
            LOOP_EXIT_TYPE exitType;
            JsBooleanValue bVal;
            bool first = true;
            bool fBreak = false;
            DebugContext dCtx = ctx.getDbgCtx();
            endIdx = curIdx + 1;

            JsOpFunction_for funcFor = instructions[curIdx][j] as JsOpFunction_for;
            if (funcFor == null)
                return null;
            funcFor.setDebugContext(dCtx);
            if (null == funcFor.initialize(ctx, rootElement))
                return null;

            int state = 0;
            int length = instructions.Count;

            while (true)
            {
                if (!first)
                {
                    if (null == funcFor.repeat(ctx, rootElement))
                        return null;
                }
                first = false;
                bVal = funcFor.evaluate(ctx, rootElement) as JsBooleanValue;
                if (bVal == null)
                    return null;
                if (!bVal.getValue())
                    break;

                state = 0;
                for (int i = curIdx + 1; i < length; i++)
                {

                    List<JsVariant> val1 = instructions[i];
                    if (val1.Count == 0)
                        continue;

                    JsVariant val = val1[0];

                    if (val is JsOpFunction_if)
                    {
                        switch (state)
                        {
                            case 0:
                                if (null == Execute_if(ctx, rootElement,
                                    instructions, i, 0, out endIdx, out exitType))
                                    return null;
                                i = endIdx;
                                state = 2;
                                if (exitType == LOOP_EXIT_TYPE.BREAK)
                                {
                                    fBreak = true;
                                    curIdx = endIdx;
                                    goto LABEL_END_WHILE;
                                }
                                else if (exitType == LOOP_EXIT_TYPE.CONTINUE)
                                {
                                    goto LABEL_END_FOR;
                                }
                                break;
                            case 1:
                                if (null == Execute_if(ctx, rootElement,
                                    instructions, i, 0, out endIdx, out exitType))
                                    return null;
                                i = endIdx;
                                if (exitType == LOOP_EXIT_TYPE.BREAK)
                                {
                                    fBreak = true;
                                    curIdx = endIdx;
                                    goto LABEL_END_WHILE;
                                }
                                else if (exitType == LOOP_EXIT_TYPE.CONTINUE)
                                {
                                    goto LABEL_END_FOR;
                                }
                                break;
                            default:
                                return null;
                        }
                    }
                    else if (val is JsOpFunction_for)
                    {
                        switch (state)
                        {
                            case 0:
                                if (null == Execute_for(ctx, rootElement,
                                    instructions, i, 0, out endIdx))
                                    return null;
                                i = endIdx;
                                state = 2;
                                break;
                            case 1:
                                if (null == Execute_for(ctx, rootElement,
                                    instructions, i, 0, out endIdx))
                                    return null;
                                i = endIdx;
                                break;
                            default:
                                return null;
                        }
                    }
                    else if (val is JsLoopBreak)
                    {
                        fBreak = true;
                        curIdx = i;
                        goto LABEL_END_WHILE;
                    }
                    else if (val is JsLoopContinue)
                    {
                        goto LABEL_END_FOR;
                    }
                    else if (val is JsL_CURLY_Bracket)
                    {
                        ((JsL_CURLY_Bracket)val).setDebugContext(dCtx);
                        if (state != 0)
                            return null;
                        state = 1;
                    }
                    else if (val is JsR_CURLY_Bracket)
                    {
                        ((JsR_CURLY_Bracket)val).setDebugContext(dCtx);
                        if (state == 0)
                            return null;
                        endIdx = i;
                        state = 0;
                        goto LABEL_END_FOR;
                    }
                    else if (val is JsFunction)
                    {
                        JsFunction func = (JsFunction)val;
                        switch (state)
                        {
                            case 0://if () single line
                                if (null == func.Execute(ctx, rootElement))
                                    return null;
                                endIdx = i;
                                goto LABEL_END_FOR;
                            case 1://if(){ multi lines}
                                if (null == func.Execute(ctx, rootElement))
                                    return null;
                                break;
                            default:
                                return null;
                        }
                    }
                    else
                    {
                        return null;
                    }
                }
    LABEL_END_FOR: ;
            }
    LABEL_END_WHILE:
            if (fBreak)
            {
                if (state == 0)
                {
                    endIdx = curIdx + 1;
                }
                else
                {
                    for (int i = curIdx + 1; i < length; i++)
                    {

                        List<JsVariant> val1 = instructions[i];
                        if (val1.Count == 0)
                            continue;

                        JsR_CURLY_Bracket rCurrly = val1[0] as JsR_CURLY_Bracket;
                        if (rCurrly != null)
                        {
                            endIdx = i;
                            break;
                        }
                    }
                }
            }
            return JsUndefValue.getConstant();
        }
    }
}
