﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NT2chCtrl.html.js
{
    public class JsIdentifier : JsVariant
    {
        string mName;
        bool mLocal;
        public JsIdentifier(string name, bool local)
        {
            mName = name;
            mLocal = local;
        }
        public string getName() { return mName; }
        public bool isLocal() { return mLocal; }

    }

    public class JsStringValue : JsVariant
    {
        static JsStringValue mStrEmpty = new JsStringValue("");
        string mVal;
        public JsStringValue(string sVal)
        {
            mVal = sVal;
        }
        public string getValue() { return mVal; }
        public override JsStringValue getStringValue() { return this; }
        public override JsBooleanValue getBooleanValue()
        {
            if (mVal == null || mVal.Length == 0)
                return new JsBooleanValue(false);
            else
                return new JsBooleanValue(true);
        }
        public override JsNumberValue getNumberValue()
        {
            double dVal;
            if (double.TryParse(mVal, out dVal))
                return new JsNumberValue(dVal);
            return new JsNumberValue(double.NaN);
            //return base.getNumberValue();
        }

        public static JsStringValue getEmpty()
        {
            return mStrEmpty;
        }
    }
    public class JsNumberValue : JsVariant
    {
        double mVal;
        public JsNumberValue(double dVal)
        {
            mVal = dVal;
        }
        public override JsStringValue getStringValue()
        {
            return new JsStringValue(mVal.ToString());
        }

        public bool IsNaN()
        {
            return double.IsNaN(mVal);
        }

        public override JsBooleanValue getBooleanValue()
        {
            if (double.IsNaN(mVal))
                return new JsBooleanValue(false);

            if (mVal == 0)
                return new JsBooleanValue(false);

            return new JsBooleanValue(true);
        }
        public double getValue() { return mVal; }
        public override JsNumberValue getNumberValue()
        {
            return this;
        }

    }
    public class JsBooleanValue : JsVariant
    {
        static JsBooleanValue gFalseValue = new JsBooleanValue(false);
        static JsBooleanValue gTrueValue = new JsBooleanValue(true);

        public static JsBooleanValue getFalseValue() { return gFalseValue; }
        public static JsBooleanValue getTrueValue() { return gTrueValue; }
        public static JsBooleanValue getConstantValue(bool value) { return value ?  gTrueValue : gFalseValue; }

        bool? mVal;
        public JsBooleanValue()
        {
            mVal = null;
        }
        public JsBooleanValue(bool dVal)
        {
            mVal = dVal;
        }
        public override JsStringValue getStringValue()
        {
            string str;
            if (mVal.HasValue && (bool)mVal)
                str = "true";
            else
                str = "false";
            return new JsStringValue(str);
        }
        public override JsNumberValue getNumberValue()
        {
            
            if (mVal.HasValue && (bool)mVal)
                return new JsNumberValue(1);
            else
                return new JsNumberValue(0);
        }


        public override JsBooleanValue getBooleanValue()
        {
            return this;
        }
        public bool getValue()
        {
            if (mVal.HasValue)
                return (bool)mVal;
            return false;
        }

    }

}
