﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.IO;
using System.Net;
using System.Net.Cache;
using System.Text;
using System.Threading;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace NT2chObject
{
    public class ThumbnailImageHelper
    {
        static LineGeometry[] mLg;
        static Brush mRed;
        static Brush mBlue;
        static Brush mBlack;
        static Brush mAqua;
        static Thickness mThick2;
        static Thickness mThick4;

        static ThumbnailImageHelper()
        {
            mLg = new LineGeometry[4];

            mLg[0] = new LineGeometry(
                 new Point(0, 0), new Point(0, 20));

            mLg[1] = new LineGeometry(
                new Point(0, 0), new Point(20, 0));

            mLg[2] = new LineGeometry(
                new Point(20, 0), new Point(20, 20));

            mLg[3] = new LineGeometry(
                new Point(0, 20), new Point(20, 20));

            mRed = new SolidColorBrush(Colors.Red);
            mBlue = new SolidColorBrush(Colors.Blue);
            mBlack = new SolidColorBrush(Colors.Black);
            mAqua = new SolidColorBrush(Colors.Aqua);

            mThick2 = new Thickness(2);
            mThick4 = new Thickness(4);

        }

        InlineUIContainer mContainer;
        //Image mImage;

        ThumbnailImageHelper(InlineUIContainer container)
        {
            mContainer = container;
            //mImage = null;
        }

        public InlineUIContainer GetContainer()
        {
            return mContainer;
        }


        public static ThumbnailImageHelper
            CreateInstance(string url)
        {
            InlineUIContainer uiContainer = new InlineUIContainer();

            System.Windows.Shapes.Path path = new System.Windows.Shapes.Path();
            path.Fill = mRed;
            path.Opacity = 1;
            path.Stroke = mBlack;
            path.Margin = new Thickness(5, 0, 5, 0);
            Rect rect = new Rect(9, 2, 2, 16);

            GeometryGroup gg = new GeometryGroup();
            //gg.FillRule = FillRule.Nonzero;

            DoubleAnimation animation = new DoubleAnimation();
            animation.From = 0;
            animation.To = 360;
            animation.Duration = TimeSpan.FromSeconds(1);
            animation.RepeatBehavior = RepeatBehavior.Forever;

            RotateTransform rotate = new RotateTransform(
                0, 10, 10);
            RectangleGeometry rg = new RectangleGeometry(rect, 0, 0, rotate);
            gg.Children.Add(rg);

            gg.Children.Add(mLg[0]);
            gg.Children.Add(mLg[1]);
            gg.Children.Add(mLg[2]);
            gg.Children.Add(mLg[3]);

            path.Data = gg;
            uiContainer.Child = path;

            ThumbnailImageHelper helper = new ThumbnailImageHelper(uiContainer);
            
            rotate.BeginAnimation(RotateTransform.AngleProperty, animation);

            return helper;
        }

        public void SetImage(Image image)
        {
            if (image == null)
                return;

            Border border = new Border();
            border.BorderBrush = mBlue;
            border.BorderThickness = mThick2;
            border.Child = image;

            image.MouseEnter += image_MouseEnter;
            image.MouseLeave += image_MouseLeave;

            mContainer.Child = border;

        }

        void image_MouseLeave(object sender, System.Windows.Input.MouseEventArgs e)
        {
            Image img = sender as Image;
            if (img == null)
                return;
            Border border = img.Parent as Border;
            if (border == null)
                return;

            border.BorderBrush = new SolidColorBrush(Colors.Blue);
            //border.BorderThickness = new Thickness(2);
        }

        void image_MouseEnter(object sender, System.Windows.Input.MouseEventArgs e)
        {
            Image img = sender as Image;
            if (img == null)
                return;
            Border border = img.Parent as Border;
            if (border == null)
                return;

            border.BorderBrush = new SolidColorBrush(Colors.Red);
            //border.BorderThickness = mThick4;
        }
     }
}
