﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace NT2chView
{
    /// <summary>
    /// NTBoardPanel.xaml の相互作用ロジック
    /// </summary>
    public partial class NTBoardPanel : UserControl



    {

        public MainWindow.DelegateMsgOpenThreadTitleListRequest OpenThreadTitleListRequest
        {
            get;
            set;
        }

        public NTBoardPanel()
        {
            InitializeComponent();
        }

        List<NTBoard> mBoardTable;

        public List<NTBoard> BoardTable
        {
            get 
            {
                return mBoardTable;
            }
            set
            {
                mBoardTable = value;
                initBoard();
            }
        }

        private void initBoard()
        {
            if(mBoardTable == null)
                return;

            //Brush brush = (Brush)TryFindResource("BasicBkBrush");

            Style style = (Style)TryFindResource("BoardDisplayButton");

            mMainPanel.Children.Clear();
            Button btn;

            foreach(NTBoard board in mBoardTable)
            {
                btn = new Button();
                if(style != null)
                    btn.Style = style;
                btn.Content = board.mName;
                btn.Tag = board;
                btn.Click += btn_Click;
                btn.MouseRightButtonDown += btn_MouseRightButtonDown;
                btn.MouseRightButtonUp += btn_MouseRightButtonUp;
                mMainPanel.Children.Add(btn);
            }
        }

        void btn_MouseRightButtonUp(object sender, MouseButtonEventArgs e)
        {
            Button btn = sender as Button;
            if (btn == null)
                return;

            NTBoard board = btn.Tag as NTBoard;
            if (board == null)
                return;

            NTBoardPopupMenu popup = new NTBoardPopupMenu(board.mName);
            popup.OnNotifiAddBoardToFavorite += 
                    new NTBoardPopupMenu.DelegateMsgOnNotifiAddBoardToFavorite(
                    OnNotifiAddBoardToFavorite);
            popup.show();
            e.Handled = true;
        }

        void btn_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
        {
            e.Handled = true;
        }

        void btn_Click(object sender, RoutedEventArgs e)
        {
            if (OpenThreadTitleListRequest == null)
                return;
            Button btn = sender as Button;
            if (btn == null)
                return;

            NTBoard board = btn.Tag as NTBoard;
            if (board == null)
                return;

            OpenThreadTitleListRequest(board);
        }

        void OnNotifiAddBoardToFavorite(string boardName)
        {
            NTAppState.getMainWindow().addFavoriteBoard(boardName);
        }
    }
}
