﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Documents;
using System.Windows.Media;

namespace NT2chView
{
    class NTFavoriteThreadPopupMenu : Popup
    {
        public delegate void DelegateMsgOnNotifiDeleteFavoriteThread(NTFavoriteThread thread);
        public event DelegateMsgOnNotifiDeleteFavoriteThread OnNotifiDeleteFavoriteThread;

        NTFavoriteThread mFavoriteThread;

        public void show()
        {
            IsOpen = true;
            Placement = PlacementMode.Mouse;
            Focus();
        }

        public NTFavoriteThreadPopupMenu(NTFavoriteThread ft)
            : base()
        {

            mFavoriteThread = ft;
 
            this.StaysOpen = false;
            //this.MouseLeave += NTResPopupMenu_MouseLeave;
            //this.LostFocus += NTResPopupMenu_LostFocus;
            
            

            StackPanel sp = new StackPanel();
            sp.Orientation = Orientation.Horizontal;


            StackPanel panel = new StackPanel();
            Border border = new Border();
            border.BorderThickness = new System.Windows.Thickness(1);
            border.BorderBrush = new SolidColorBrush(Colors.DarkGray);
           

            ListBoxItem item1 = new ListBoxItem();

            sp = new StackPanel();
            //sp.MouseLeftButtonDown += threadTitle_MouseLeftButtonDown;
            sp.Children.Add(new TextBlock(new Run(ft.Title)));
            //sp.Tag = tt;
            item1.Content = sp;
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            //item1.Tag = tt;
            //item1.MouseEnter += item1_MouseEnter;
            //item1.MouseLeave += item1_MouseLeave;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new Separator());
            item1 = new ListBoxItem();
            item1.BorderBrush = new SolidColorBrush(Colors.LightGray);
            item1.BorderThickness = new System.Windows.Thickness(1);
            item1.Height = 1;
            item1.Content = sp;
            panel.Children.Add(item1);
            panel.Background = new SolidColorBrush(Colors.White);


            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("お気に入りから削除")));
            sp.MouseLeftButtonDown += itemDelete_MouseLeftButtonDown;
            sp.Tag = ft;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            //item1.MouseEnter += item1_MouseEnter;
            //item1.MouseLeave += item1_MouseLeave;
            //item1.MouseLeftButtonDown += item1_MouseLeftButtonDown;
            //item1.MouseLeftButtonUp += item1_MouseLeftButtonUp;
            panel.Children.Add(item1);
 

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("閉じる")));
            sp.MouseLeftButtonDown += itemClose_MouseLeftButtonDown;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            //item1.MouseEnter += item1_MouseEnter;
            //item1.MouseLeave += item1_MouseLeave;
            //item1.MouseLeftButtonDown += item1_MouseLeftButtonDown;
            //item1.MouseLeftButtonUp += item1_MouseLeftButtonUp;
            panel.Children.Add(item1);
            //this.Child = panel;
            border.Child = panel; 
            this.Child = border;

        }

        void itemDelete_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            if (OnNotifiDeleteFavoriteThread != null)
            {
                OnNotifiDeleteFavoriteThread(mFavoriteThread);
            }
        }

        void itemClose_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            //Hide();
            IsOpen = false;
            //mMainWnd.NgEdit_setResSection(mRes);
        }
    }
}
