﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chView
{
    public class NTFavoriteThreadTag
    {
        string mTagName;
        int mCount;
        bool mOpened = false;
        bool mAutoUpdate = true;
        List<NTFavoriteThread> mThreadList = new List<NTFavoriteThread>();

        public bool Opened()
        {
            return mOpened;
        }

        public string getTagName()
        {
            return mTagName;
        }
        public void setTagName(string  tagName)
        {
            mTagName = tagName;
        }

        public List<NTFavoriteThread> getThreadList()
        {
            return mThreadList;
        }

        public int getCount()
        {
            return mCount;
        }

        public void setCount(int value)
        {
            if (value < 0)
                return;
            mCount = value;
        }

        public void add(NTFavoriteThread thread)
        {
            mThreadList.Add(thread);
        }

        public NTFavoriteThreadTag(string tagName, string count, string attr)
        {
            mTagName = tagName;
            int nCnt;
            if (int.TryParse(count, out nCnt))
                mCount = nCnt;
            else
                mCount = 0;

            if (0 <= attr.IndexOf("open"))
                mOpened = true;
            else
                mOpened = false;
            if (0 <= attr.IndexOf("update"))
                mAutoUpdate = true;
            else
                mAutoUpdate = false;
        }

        public string getDescription()
        {
            StringBuilder sb = new StringBuilder(mTagName.Length+16);
            sb.Append(mTagName).Append(',').Append(mCount.ToString()).Append(',');
            if (mOpened)
                sb.Append("open ");
            if (mAutoUpdate)
                sb.Append("update ");
            return sb.ToString();
        }

    }
}
